/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.imageio.ImageIO;
import ltd.liuzhi.rhyme.utils.CodeDO;
import ltd.liuzhi.rhyme.utils.CodeTask;
import ltd.liuzhi.rhyme.utils.ImgFontByte;
import ltd.liuzhi.rhyme.utils.MyDateUtils;
import ltd.liuzhi.rhyme.utils.pojo.domain.ImgCodeDO;
import sun.misc.BASE64Encoder;

public class MyImgVerificationCodeUtils {
    private static int width = 110;
    private static int height = 40;
    private static int codeCount = 4;
    private static int lineCount = 50;
    private static Map<String, CodeDO> map = new HashMap<String, CodeDO>();
    private static char[] codeSequence = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static Random random = new Random();
    private static int expirationTime = 300;

    public static void setExpirationTime(int expirationTime) {
        MyImgVerificationCodeUtils.expirationTime = expirationTime;
    }

    public static Boolean verification(ImgCodeDO imgCodeDO) {
        if (imgCodeDO.getId() == null || imgCodeDO.getCode() == null) {
            return null;
        }
        CodeDO codeDO = map.get(imgCodeDO.getId());
        if (codeDO == null) {
            return null;
        }
        if (MyDateUtils.differentSecondByMillisecond(codeDO.getCreateTime(), new Date()) > expirationTime) {
            map.remove(imgCodeDO.getId());
            return null;
        }
        Boolean b = codeDO.getCode().trim().equalsIgnoreCase(imgCodeDO.getCode().trim());
        if (b.booleanValue()) {
            map.remove(imgCodeDO.getId());
        }
        return b;
    }

    public static Boolean verification(String id, String code) {
        return MyImgVerificationCodeUtils.verification(new ImgCodeDO(id, code));
    }

    public static ImgCodeDO createImgCodeToBase64() {
        ImgCodeDO imgCodeDO = new ImgCodeDO();
        int fontHeight = height - 5;
        int codeX = width / (codeCount + 3);
        BufferedImage buffImg = new BufferedImage(width, height, 1);
        Graphics2D g = buffImg.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, width, height);
        ImgFontByte imgFont = new ImgFontByte();
        Font font = imgFont.getFont(fontHeight);
        g.setFont(font);
        StringBuffer randomCode = new StringBuffer();
        for (int i = 0; i < codeCount; ++i) {
            String strRand = String.valueOf(codeSequence[random.nextInt(codeSequence.length)]);
            g.setColor(MyImgVerificationCodeUtils.getRandomColor());
            g.drawString(strRand, (i + 1) * codeX, MyImgVerificationCodeUtils.getRandomNumber(height / 2) + 25);
            randomCode.append(strRand);
        }
        String code = randomCode.toString();
        imgCodeDO.setCode(code);
        imgCodeDO.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)buffImg, "JPEG", baos);
            byte[] bytes = baos.toByteArray();
            String data = "data:image/png;base64," + new BASE64Encoder().encodeBuffer(bytes).trim();
            data.replaceAll("\\s", "");
            imgCodeDO.setData(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CodeDO codeDO = new CodeDO(imgCodeDO.getId(), imgCodeDO.getCode());
        map.put(imgCodeDO.getId(), codeDO);
        return imgCodeDO;
    }

    private static Color getRandomColor() {
        int r = MyImgVerificationCodeUtils.getRandomNumber(255);
        int g = MyImgVerificationCodeUtils.getRandomNumber(255);
        int b = MyImgVerificationCodeUtils.getRandomNumber(255);
        return new Color(r, g, b);
    }

    private static int getRandomNumber(int number) {
        return random.nextInt(number);
    }

    public static void overdueCleared() {
        Set<Map.Entry<String, CodeDO>> set = map.entrySet();
        for (Map.Entry<String, CodeDO> entry : set) {
            Date createTime = entry.getValue().getCreateTime();
            if (MyDateUtils.differentSecondByMillisecond(createTime, new Date()) <= expirationTime) continue;
            map.remove(entry.getKey());
        }
    }

    static {
        Timer timer = new Timer();
        CodeTask codeTask = new CodeTask();
        timer.schedule((TimerTask)codeTask, new Date(), 60000L);
    }
}

