/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class MyEncryptionUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String EMPTY_STR = "";
    private static final int AES_KEY_SIZE = 16;
    private static final String ENCRYPT = "AES";
    private static final String CIPHER = "AES/CBC/PKCS5Padding";
    private static final String ALGORITHM = "DESede";
    private static final String CIPHER_ALGORITHM_ECB = "DESede/ECB/PKCS5Padding";
    private static final String DES_ALGORITHM = "DES";
    public static final String DES_CIPHER_ALGORITHM = "DES";

    public static final String aesEncrypt(String src, String key) {
        if (key == null || src == null) {
            return EMPTY_STR;
        }
        try {
            byte[] bs = MyEncryptionUtils.getAESResult(key, src.getBytes(DEFAULT_CHARSET), 1);
            if (bs != null) {
                return Base64.getEncoder().encodeToString(bs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return src;
    }

    public static final String aesDecrypt(String src, String key) {
        if (key == null || src == null) {
            return EMPTY_STR;
        }
        try {
            byte[] bs = MyEncryptionUtils.getAESResult(key, Base64.getDecoder().decode(src.getBytes(DEFAULT_CHARSET)), 2);
            if (bs != null) {
                return new String(bs, DEFAULT_CHARSET);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return src;
    }

    private static byte[] getAESResult(String key, byte[] textBytes, int encryptMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        SecretKeySpec newKey = new SecretKeySpec(MyEncryptionUtils.buildCLenKey(key, 16), ENCRYPT);
        Cipher cipher = Cipher.getInstance(ENCRYPT);
        cipher.init(encryptMode, (Key)newKey, new SecureRandom());
        return cipher.doFinal(textBytes);
    }

    public static final String tripleDesEncrypt(String src, String key) {
        if (key == null || src == null) {
            return EMPTY_STR;
        }
        try {
            byte[] des = MyEncryptionUtils.getTripleDESResult(key, src.getBytes(), 1);
            if (des != null) {
                return Base64.getEncoder().encodeToString(des);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return src;
    }

    public static final String tripleDesDecrypt(String src, String key) {
        if (key == null || src == null) {
            return EMPTY_STR;
        }
        try {
            byte[] srcb = Base64.getDecoder().decode(src);
            byte[] des = MyEncryptionUtils.getTripleDESResult(key, srcb, 2);
            return new String(des, DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            return src;
        }
    }

    private static byte[] getTripleDESResult(String key, byte[] textBytes, int encryptMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        SecretKeySpec newKey = new SecretKeySpec(MyEncryptionUtils.buildCLenKey(key, 24), ALGORITHM);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM_ECB);
        cipher.init(encryptMode, (Key)newKey, new SecureRandom());
        return cipher.doFinal(textBytes);
    }

    private static byte[] buildCLenKey(String keyStr, int lgn) throws UnsupportedEncodingException {
        byte[] key = new byte[lgn];
        byte[] temp = keyStr.getBytes(DEFAULT_CHARSET);
        if (key.length > temp.length) {
            System.arraycopy(temp, 0, key, 0, temp.length);
        } else {
            System.arraycopy(temp, 0, key, 0, key.length);
        }
        return key;
    }

    public static final String desEncrypt(String src, String key) {
        if (key == null || src == null) {
            return EMPTY_STR;
        }
        try {
            byte[] des = MyEncryptionUtils.getDESResult(key, src.getBytes(), 1);
            if (des != null) {
                return Base64.getEncoder().encodeToString(des);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return src;
    }

    public static final String desDecrypt(String src, String key) {
        if (key == null || src == null) {
            return EMPTY_STR;
        }
        try {
            byte[] srcb = Base64.getDecoder().decode(src);
            byte[] des = MyEncryptionUtils.getDESResult(key, srcb, 2);
            return new String(des, DEFAULT_CHARSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            return src;
        }
    }

    private static byte[] getDESResult(String key, byte[] textBytes, int encryptMode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        SecretKeySpec newKey = new SecretKeySpec(MyEncryptionUtils.buildCLenKey(key, 8), "DES");
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(encryptMode, (Key)newKey, new SecureRandom());
        return cipher.doFinal(textBytes);
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

