/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import ltd.liuzhi.rhyme.utils.MyFileUtils;
import ltd.liuzhi.rhyme.utils.MyStringUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class MyImageUtils {
    public static byte[] imgBase64ToBytes(String base64) {
        BASE64Decoder decoder = new BASE64Decoder();
        base64 = base64.replaceAll("data:image/png;base64,", "");
        byte[] bytes = null;
        try {
            bytes = decoder.decodeBuffer(base64);
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] >= 0) continue;
                int n = i;
                bytes[n] = (byte)(bytes[n] + 256);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static String bytesToImgBase64(byte[] bytes) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(bytes);
    }

    public static byte[] imgToBytes(String imgPath) {
        File file = new File(imgPath);
        BufferedImage bi = null;
        ByteArrayOutputStream baos = null;
        try {
            bi = ImageIO.read(file);
            baos = new ByteArrayOutputStream();
            int index = imgPath.lastIndexOf(".");
            String format = imgPath.substring(index + 1);
            ImageIO.write((RenderedImage)bi, format, baos);
            byte[] bytes = baos.toByteArray();
            baos.close();
            return bytes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void bytesToImg(byte[] bytes, String savePath) {
        ByteArrayInputStream baos = new ByteArrayInputStream(bytes);
        try {
            BufferedImage bi = ImageIO.read(baos);
            File file = new File(savePath);
            ImageIO.write((RenderedImage)bi, "png", file);
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File imgFormatConvert(String imgPath, String formatName) {
        return MyImageUtils.imgFormatConvert(new File(imgPath), formatName);
    }

    public static File imgFormatConvert(File file, String formatName) {
        MyFileUtils.checkFileExists(file);
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ImageIO.write((RenderedImage)bi, formatName, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static byte[] toTransparency(InputStream is) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BufferedImage bi;
            BufferedImage image = bi = ImageIO.read(is);
            ImageIcon imageIcon = new ImageIcon(image);
            BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
            Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
            g2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
            int alpha = 0;
            for (int j1 = bufferedImage.getMinY(); j1 < bufferedImage.getHeight(); ++j1) {
                for (int j2 = bufferedImage.getMinX(); j2 < bufferedImage.getWidth(); ++j2) {
                    int rgb = bufferedImage.getRGB(j2, j1);
                    int R = (rgb & 0xFF0000) >> 16;
                    int G = (rgb & 0xFF00) >> 8;
                    int B = rgb & 0xFF;
                    if (255 - R < 30 && 255 - G < 30 && 255 - B < 30) {
                        rgb = alpha + 1 << 24 | rgb & 0xFFFFFF;
                    }
                    bufferedImage.setRGB(j2, j1, rgb);
                }
            }
            g2D.drawImage((Image)bufferedImage, 0, 0, imageIcon.getImageObserver());
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Boolean imageCheck(File file) {
        MyFileUtils.checkFileExists(file);
        try {
            BufferedImage image = ImageIO.read(file);
            return image != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean changeSize(File file, int newWidth, int newHeight) {
        MyFileUtils.checkFileExists(file);
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            BufferedImage bi = ImageIO.read(in);
            BufferedImage tag = new BufferedImage(newWidth, newHeight, 1);
            tag.getGraphics().drawImage(bi, 0, 0, newWidth, newHeight, null);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            ImageIO.write((RenderedImage)tag, "PNG", out);
            in.close();
            out.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean changeSize(String path, int newWidth, int newHeight) {
        return MyImageUtils.changeSize(new File(path), newWidth, newHeight);
    }

    public static File changeSizeToNewFile(String path, int newWidth, int newHeight) {
        return MyImageUtils.changeSizeToNewFile(new File(path), newWidth, newHeight);
    }

    public static File changeSizeToNewFile(File file, int newWidth, int newHeight) {
        MyFileUtils.checkFileExists(file);
        File newFile = new File(MyStringUtils.getRandom(6) + "." + MyFileUtils.getFilePostfix(file));
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            BufferedImage bi = ImageIO.read(in);
            BufferedImage tag = new BufferedImage(newWidth, newHeight, 1);
            tag.getGraphics().drawImage(bi, 0, 0, newWidth, newHeight, null);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
            ImageIO.write((RenderedImage)tag, "PNG", out);
            in.close();
            out.close();
            return newFile;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

