/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ltd.liuzhi.rhyme.utils.MyUtils;

public class MyObjectUtils {
    private MyObjectUtils() {
    }

    public static <T> T newInstance(Class<?> clazz) {
        return (T)MyObjectUtils.instantiate(clazz);
    }

    public static <T> T newInstance(String clazzStr) {
        try {
            Class<?> clazz = Class.forName(clazzStr);
            return MyObjectUtils.newInstance(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T instantiate(Class<T> clazz) {
        MyUtils.notNull(clazz, "Class must not be null");
        if (clazz.isInterface()) {
            throw new RuntimeException("\u4e0d\u80fd\u5bf9\u63a5\u53e3\u5b9e\u4f8b\u5316");
        }
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException var2) {
            throw new RuntimeException("\u4e0d\u80fd\u5bf9\u62bd\u8c61\u7c7b\u521b\u5efa\u5b9e\u4f8b");
        }
        catch (IllegalAccessException var3) {
            throw new RuntimeException("\u6539\u7c7b\u6784\u9020\u51fd\u6570\u79c1\u6709\u5316\u4e0d\u80fd\u521b\u5efa\u5b9e\u4f8b");
        }
    }

    public static <T> List replaceListObj(List list, Class<T> clazz) {
        Iterator iterator = list.iterator();
        ArrayList<T> newList = new ArrayList<T>();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            T newObj = MyObjectUtils.copy(obj, clazz);
            newList.add(newObj);
        }
        return newList;
    }

    public static <T> T copy(Object obj, Class<T> clazz) {
        T to = MyObjectUtils.newInstance(clazz);
        if (obj == null) {
            return to;
        }
        Class<?> source = obj.getClass();
        Field[] sourceFields = source.getDeclaredFields();
        Field[] targetFields = clazz.getDeclaredFields();
        for (Field sourceField : sourceFields) {
            for (Field targetField : targetFields) {
                if (!sourceField.getName().equalsIgnoreCase(targetField.getName()) || sourceField.getType() != targetField.getType()) continue;
                sourceField.setAccessible(true);
                targetField.setAccessible(true);
                try {
                    targetField.set(to, sourceField.get(obj));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return to;
    }

    public static <T> void copyNotEmpty(T sourceObj, T targetObj) {
        Class<?> source;
        if (sourceObj == null) {
            return;
        }
        Class<?> target = targetObj.getClass();
        if (target != (source = sourceObj.getClass())) {
            throw new RuntimeException("\u5bf9\u8c61\u4e0d\u4e00\u81f4\u4e0d\u5141\u8bb8\u62f7\u8d1d");
        }
        Field[] sourceFields = source.getDeclaredFields();
        Field[] targetFields = target.getDeclaredFields();
        for (Field sourceField : sourceFields) {
            sourceField.setAccessible(true);
            try {
                Object obj = sourceField.get(sourceObj);
                if (MyObjectUtils.objIsEmpty(obj)) continue;
                for (Field targetField : targetFields) {
                    if (!sourceField.getName().equalsIgnoreCase(targetField.getName()) || sourceField.getType() != targetField.getType()) continue;
                    targetField.setAccessible(true);
                    if (!MyObjectUtils.objIsEmpty(targetField.get(targetObj))) continue;
                    targetField.set(targetObj, obj);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean objIsEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.trim().equals("")) {
                return true;
            }
        } else {
            if (obj instanceof Collection) {
                return ((Collection)obj).isEmpty();
            }
            if (obj instanceof Map) {
                return ((Map)obj).isEmpty();
            }
        }
        return false;
    }
}

