/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MyDateUtils {
    private MyDateUtils() {
    }

    public static Date getYesterdayTime() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getAssignZeroTime(Date date, Integer day) {
        Calendar cal = Calendar.getInstance();
        if (date == null) {
            date = new Date();
        }
        cal.setTime(date);
        cal.add(5, day == null ? 0 : day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date addAssignTime(Date date, Integer day) {
        Calendar cal = Calendar.getInstance();
        if (date == null) {
            date = new Date();
        }
        cal.setTime(date);
        cal.add(5, day == null ? 0 : day);
        return cal.getTime();
    }

    public static Date getAssignZeroTime(Date date) {
        return MyDateUtils.getAssignZeroTime(date, null);
    }

    public static Date getAssignZeroTime(Integer integer) {
        Date date = MyDateUtils.getAssignTime(integer);
        return MyDateUtils.getAssignZeroTime(date, null);
    }

    public static Date getAssignEndTime(Integer integer) {
        Date date = MyDateUtils.getAssignTime(integer);
        return MyDateUtils.getAssignEndTime(date, null);
    }

    public static Date getAssignEndTime(Date date) {
        return MyDateUtils.getAssignEndTime(date, null);
    }

    public static Date getTodayEndTime() {
        return MyDateUtils.getAssignEndTime(null, null);
    }

    private static Date getAssignEndTime(Date date, Integer day) {
        Calendar cal = Calendar.getInstance();
        if (date == null) {
            date = new Date();
        }
        cal.setTime(date);
        cal.add(5, day == null ? 0 : day);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getTodayZeroTime() {
        return MyDateUtils.getAssignZeroTime(new Date());
    }

    public static Date addAssignTime(Integer year, Integer month, Integer day, Integer hour, Integer minute, Integer second) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, year == null ? 0 : year);
        cal.add(2, month == null ? 0 : month);
        cal.add(5, day == null ? 0 : day);
        cal.add(11, hour == null ? 0 : hour);
        cal.add(12, minute == null ? 0 : minute);
        cal.add(13, second == null ? 0 : second);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date addAssignTime(Integer year, Integer month, Integer day, Integer hour, Integer minute) {
        return MyDateUtils.addAssignTime(year, month, day, hour, minute, null);
    }

    public static Date addAssignTime(Integer year, Integer month, Integer day, Integer hour) {
        return MyDateUtils.addAssignTime(year, month, day, hour, null, null);
    }

    public static Date addAssignTime(Integer year, Integer month, Integer day) {
        return MyDateUtils.addAssignTime(year, month, day, null, null, null);
    }

    public static Date addAssignTime(Integer year, Integer month) {
        return MyDateUtils.addAssignTime(year, month, null, null, null, null);
    }

    public static Date addAssignTimeYear(Integer year) {
        return MyDateUtils.addAssignTime(year, null, null, null, null, null);
    }

    public static Date addAssignTimeMonth(Integer month) {
        return MyDateUtils.addAssignTime(null, month, null, null, null, null);
    }

    public static Date addAssignTimeDay(Integer day) {
        return MyDateUtils.addAssignTime(null, null, day, null, null, null);
    }

    public static Date addAssignTimeHour(Integer hour) {
        return MyDateUtils.addAssignTime(null, null, null, hour, null, null);
    }

    public static Date addAssignTimeMinute(Integer minute) {
        return MyDateUtils.addAssignTime(null, null, null, null, minute, null);
    }

    public static Date addAssignTimeSecond(Integer second) {
        return MyDateUtils.addAssignTime(null, null, null, null, null, second);
    }

    public static Date getAssignTime(Integer day, Integer hour, Integer minute, Integer second) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, day == null ? 0 : day);
        cal.set(11, hour == null ? cal.get(11) : hour.intValue());
        cal.set(12, minute == null ? cal.get(12) : minute.intValue());
        cal.set(13, second == null ? cal.get(13) : second.intValue());
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getAssignTime() {
        return MyDateUtils.getAssignTime(null);
    }

    public static Date getAssignTime(Integer day) {
        return MyDateUtils.getAssignTime(day, null);
    }

    public static Date getAssignTime(Integer day, Integer hour) {
        return MyDateUtils.getAssignTime(day, hour, null);
    }

    public static Date getAssignTime(Integer day, Integer hour, Integer minute) {
        return MyDateUtils.getAssignTime(day, hour, minute, null);
    }

    public static String getTodayZeroTimeToStr() {
        return MyDateUtils.getTodayZeroTimeToStr(null);
    }

    public static String getTodayZeroTimeToStr(Boolean all) {
        return MyDateUtils.getAssignTimeToStr(MyDateUtils.getTodayZeroTime(), all);
    }

    public static String getAssignTimeToStr(Date date, Boolean all) {
        if (date == null) {
            date = new Date();
        }
        if (all == null) {
            all = true;
        }
        String str = all != false ? MyDateFormatterEnum.TIME_FORMAT_YMD_G_HMS.getFormatter() : MyDateFormatterEnum.TIME_FORMAT_YMD_G.getFormatter();
        SimpleDateFormat df = new SimpleDateFormat(str);
        return df.format(date);
    }

    public static String getTimestamp() {
        return MyDateUtils.getTimestamp(null);
    }

    public static String getTimestamp(Date date) {
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat df = new SimpleDateFormat(MyDateFormatterEnum.TIME_FORMAT_TIMESTMP.getFormatter());
        return df.format(date);
    }

    public static int differentDaysByMillisecond(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return Math.abs(days);
    }

    public static int differentSecondByMillisecond(Date date1, Date date2) {
        int second = (int)((date2.getTime() - date1.getTime()) / 1000L);
        return Math.abs(second);
    }

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return Math.abs(timeDistance + (day2 - day1));
        }
        return Math.abs(day2 - day1);
    }

    public static String stampToDate(Long s) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date(s);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public static Date dateAddDate(Date d1, Date d2) {
        long dl1 = d1.getTime();
        long dl2 = d2.getTime();
        long now = new Date().getTime();
        return new Date(dl1 + dl2 - now);
    }

    public static Date strToDate(String str) {
        String format = null;
        if (str.contains("-") && str.contains(":")) {
            format = MyDateFormatterEnum.TIME_FORMAT_YMD_G_HMS.getFormatter();
        } else if (str.contains("/") && str.length() == 10) {
            format = MyDateFormatterEnum.TIME_FORMAT_YMD_G.getFormatter();
        } else if (str.contains("/") && str.contains(":")) {
            format = MyDateFormatterEnum.TIME_FORMAT_YMD_H_HMS.getFormatter();
        } else if (str.contains("/") && str.length() == 10) {
            format = MyDateFormatterEnum.TIME_FORMAT_YMD_H.getFormatter();
        } else if (str.contains("\u5e74") && str.contains("\u6708") && str.contains("\u65e5") && str.contains(":")) {
            format = MyDateFormatterEnum.TIME_FORMAT_CHINASTMP.getFormatter();
        } else if (str.contains("\u5e74") && str.contains("\u6708") && str.contains("\u65e5") && str.length() == 10) {
            format = MyDateFormatterEnum.TIME_FORMAT_CHINA.getFormatter();
        } else if (str.length() == 14) {
            format = MyDateFormatterEnum.TIME_FORMAT_TIMESTMP.getFormatter();
        } else if (str.length() == 8) {
            format = MyDateFormatterEnum.TIME_FORMAT_YMD.getFormatter();
        }
        if (format == null) {
            throw new RuntimeException("\u88ab\u8f6c\u5316\u7684\u65e5\u671f\u4e0d\u6b63\u786e");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        try {
            return simpleDateFormat.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("\u88ab\u8f6c\u5316\u7684\u65e5\u671f\u4e0d\u6b63\u786e");
        }
    }

    public static String dateToStr(Date date, MyDateFormatterEnum dateFormatter) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormatter.getFormatter());
        return simpleDateFormat.format(date);
    }

    public static String dateToStr(Date date) {
        return MyDateUtils.dateToStr(date, MyDateFormatterEnum.TIME_FORMAT_YMD_G_HMS);
    }

    public static Boolean dateCompareGreater(Date date1, Date date2) {
        return date1.getTime() > date2.getTime();
    }

    public static String getCurrentYeay() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        return simpleDateFormat.format(new Date());
    }

    public static String getCurrentMonth() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM");
        return simpleDateFormat.format(new Date());
    }

    public static String getCurrentDay() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd");
        return simpleDateFormat.format(new Date());
    }

    public static boolean timeCompare(Date date1, Date date2) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        try {
            date1 = df.parse(MyDateUtils.dateToStr(date1, MyDateFormatterEnum.TIME_FORMAT_TIME));
            date2 = df.parse(MyDateUtils.dateToStr(date2, MyDateFormatterEnum.TIME_FORMAT_TIME));
            return date1.getTime() > date2.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("\u65f6\u95f4\u8f6c\u6362\u5931\u8d25!");
        }
    }

    public static enum MyDateFormatterEnum {
        TIME_FORMAT_YMD("yyyyMMdd"),
        TIME_FORMAT_MD("MMdd"),
        TIME_FORMAT_YMD_G_HMS("yyyy-MM-dd HH:mm:ss"),
        TIME_FORMAT_YMD_G("yyyy-MM-dd"),
        TIME_FORMAT_MD_G("MM-dd"),
        TIME_FORMAT_YMD_H("yyyy/MM/dd"),
        TIME_FORMAT_MD_H("MM/dd"),
        TIME_FORMAT_YMD_H_HMS("yyyy/MM/dd HH:mm:ss"),
        TIME_FORMAT_TIMESTMP("yyyyMMddHHmmss"),
        TIME_FORMAT_CHINA("yyyy\u5e74MM\u6708dd\u65e5"),
        TIME_FORMAT_CHINASTMP("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss"),
        TIME_FORMAT_TIME("HH:mm:ss");

        private final String formatter;

        private MyDateFormatterEnum(String formatter) {
            this.formatter = formatter;
        }

        public String getFormatter() {
            return this.formatter;
        }
    }
}

