/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MyScheduleUtils {
    private static Map<Integer, RunnableScheduledFuture> map;
    private static ScheduledThreadPoolExecutor scheduledExecutorService;

    private MyScheduleUtils() {
    }

    public static Integer newTaskByMilliseconds(Runnable runnable, long milliseconds, boolean isPeriodic) {
        return MyScheduleUtils.openTask(runnable, milliseconds, isPeriodic);
    }

    public static Integer newTaskBySeconds(Runnable runnable, int seconds, boolean isPeriodic) {
        return MyScheduleUtils.newTaskByMilliseconds(runnable, seconds * 1000, isPeriodic);
    }

    public static Integer newTaskByMinutes(Runnable runnable, int minutes, boolean isPeriodic) {
        return MyScheduleUtils.newTaskBySeconds(runnable, minutes * 60, isPeriodic);
    }

    public static Integer newTaskByHours(Runnable runnable, int hours, boolean isPeriodic) {
        return MyScheduleUtils.newTaskByMinutes(runnable, hours * 60, isPeriodic);
    }

    public static synchronized boolean shutdownTask(Integer taskFlag, boolean isCloseNow) {
        if (map == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u4efb\u52a1\u6807\u8bc6");
        }
        RunnableScheduledFuture future = map.get(taskFlag);
        if (future == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u4efb\u52a1\u6807\u8bc6");
        }
        boolean result = future.cancel(isCloseNow);
        if (result) {
            map.remove(future);
            if (map.size() == 0) {
                map = null;
                scheduledExecutorService.shutdown();
                scheduledExecutorService = null;
            }
        }
        return result;
    }

    public static RunnableScheduledFuture getTaskFuture(Integer taskFlag) {
        if (map == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u4efb\u52a1\u6807\u8bc6");
        }
        RunnableScheduledFuture future = map.get(taskFlag);
        if (future == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u4efb\u52a1\u6807\u8bc6");
        }
        return future;
    }

    public static boolean shutdownTask(Integer taskFlag) {
        return MyScheduleUtils.shutdownTask(taskFlag, false);
    }

    private static synchronized Integer openTask(Runnable runnable, long milliseconds, boolean isPeriodic) {
        if (scheduledExecutorService == null) {
            scheduledExecutorService = new ScheduledThreadPoolExecutor(5);
        }
        RunnableScheduledFuture future = isPeriodic ? (RunnableScheduledFuture)scheduledExecutorService.scheduleAtFixedRate(runnable, milliseconds, milliseconds, TimeUnit.MILLISECONDS) : (RunnableScheduledFuture)scheduledExecutorService.schedule(runnable, milliseconds, TimeUnit.MILLISECONDS);
        Integer code = future.hashCode();
        if (map == null) {
            map = new ConcurrentHashMap<Integer, RunnableScheduledFuture>();
        }
        map.put(code, future);
        return code;
    }
}

