/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import ltd.liuzhi.rhyme.utils.MyStringUtils;
import ltd.liuzhi.rhyme.utils.enums.FileTypeEnum;

public class MyFileUtils {
    private MyFileUtils() {
    }

    public static String getRealFilePostfix(String filePath) {
        if (filePath == null) {
            return "";
        }
        File file = new File(filePath);
        return MyFileUtils.getRealFilePostfix(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRealFilePostfix(File file) {
        MyFileUtils.checkFileExists(file);
        FileInputStream is = null;
        String value = "";
        try {
            is = new FileInputStream(file);
            byte[] b = new byte[20];
            is.read(b, 0, b.length);
            value = MyFileUtils.bytesToHexString(b);
        }
        catch (Exception exception) {
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return FileTypeEnum.getPostfixByHex(value);
    }

    public static String getFilePostfix(String filePath) {
        if (filePath == null) {
            return "";
        }
        return MyStringUtils.getTextRights(filePath, ".");
    }

    public static String getFilePostfix(File file) {
        if (file == null) {
            return "";
        }
        return MyStringUtils.getTextRights(file.getName(), ".");
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder builder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            String hv = Integer.toHexString(src[i] & 0xFF).toUpperCase();
            if (hv.length() < 2) {
                builder.append(0);
            }
            builder.append(hv);
        }
        System.out.println("HexString: " + builder.toString());
        return builder.toString();
    }

    public static void checkFileExists(File file) {
        if (!file.exists()) {
            throw new RuntimeException("\u88ab\u8bfb\u53d6\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
    }

    public static File fileRename(File file, String newName) {
        MyFileUtils.checkFileExists(file);
        String postfix = "." + MyFileUtils.getRealFilePostfix(file);
        String oldPath = file.getParent();
        oldPath = MyStringUtils.isEmpty(oldPath) == true ? "" : oldPath + File.separator;
        File newFile = new File(oldPath + MyStringUtils.getTextLefts(newName, ".") + postfix);
        file.renameTo(newFile);
        return newFile;
    }

    public static byte[] getBytesByFile(File file) throws Exception {
        int n;
        FileInputStream fis = new FileInputStream(file);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
        byte[] b = new byte[1000];
        while ((n = fis.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        fis.close();
        byte[] data = bos.toByteArray();
        bos.close();
        return data;
    }

    public static boolean createFileFolder(String path) {
        File fileFolder = new File(path);
        if (fileFolder.isDirectory()) {
            return true;
        }
        return fileFolder.mkdirs();
    }
}

