/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import ltd.liuzhi.rhyme.utils.CodeDO;
import ltd.liuzhi.rhyme.utils.ImgFontByte;
import ltd.liuzhi.rhyme.utils.MyDateUtils;
import ltd.liuzhi.rhyme.utils.MyScheduleUtils;
import ltd.liuzhi.rhyme.utils.pojo.domain.ImgCodeDO;
import sun.misc.BASE64Encoder;

public class MyImgVerificationCodeUtils {
    private static int width = 80;
    private static int height = 45;
    private static int codeCount = 4;
    private static int lineCount = 10;
    private static Map<String, CodeDO> map = new ConcurrentHashMap<String, CodeDO>();
    private static char[] codeSequence = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static Random random = new Random();
    private static int expirationTime = 300;

    public static void setExpirationTime(int expirationTime) {
        MyImgVerificationCodeUtils.expirationTime = expirationTime;
    }

    public static Boolean verification(ImgCodeDO imgCodeDO) {
        if (imgCodeDO.getId() == null || imgCodeDO.getCode() == null) {
            return null;
        }
        CodeDO codeDO = map.get(imgCodeDO.getId());
        if (codeDO == null) {
            return null;
        }
        if (MyDateUtils.differentSecondByMillisecond(codeDO.getCreateTime(), new Date()) > expirationTime) {
            map.remove(imgCodeDO.getId());
            return null;
        }
        Boolean b = codeDO.getCode().trim().equalsIgnoreCase(imgCodeDO.getCode().trim());
        if (b.booleanValue()) {
            map.remove(imgCodeDO.getId());
        }
        return b;
    }

    public static Boolean verification(String id, String code) {
        return MyImgVerificationCodeUtils.verification(new ImgCodeDO(id, code));
    }

    public static ImgCodeDO createImgCodeToBase64() {
        Random rand = new Random();
        ImgCodeDO imgCodeDO = new ImgCodeDO();
        int fontHeight = height - 5;
        int codeX = width / (codeCount + 3);
        BufferedImage buffImg = new BufferedImage(width, height, 1);
        Graphics2D g = buffImg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color[] colors = new Color[5];
        Color[] colorSpaces = new Color[]{Color.WHITE, Color.CYAN, Color.GRAY, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.YELLOW};
        float[] fractions = new float[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colorSpaces[MyImgVerificationCodeUtils.getRandomNumber(colorSpaces.length)];
            fractions[i] = rand.nextFloat();
        }
        Arrays.sort(fractions);
        g.setColor(Color.GRAY);
        g.fillRect(0, 0, width, height);
        Color c = MyImgVerificationCodeUtils.getRandomColor(200, 250);
        g.setColor(c);
        g.fillRect(0, 2, width, height - 4);
        MyImgVerificationCodeUtils.drawRandomLines(g, lineCount);
        float yawpRate = 0.05f;
        int area = (int)(yawpRate * (float)width * (float)height);
        for (int i = 0; i < area; ++i) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int rgb = MyImgVerificationCodeUtils.getRandomNumber(255);
            buffImg.setRGB(x, y, rgb);
        }
        MyImgVerificationCodeUtils.shear(g, width, height, c);
        g.setColor(MyImgVerificationCodeUtils.getRandomColor(100, 160));
        ImgFontByte imgFont = new ImgFontByte();
        Font font = imgFont.getFont(fontHeight - 2);
        g.setFont(font);
        StringBuffer randomCode = new StringBuffer();
        for (int i = 0; i < codeCount; ++i) {
            String strRand = String.valueOf(codeSequence[random.nextInt(codeSequence.length)]);
            g.drawString(strRand, (i + 1) * codeX, MyImgVerificationCodeUtils.getRandomNumber(height / 2) + 25);
            randomCode.append(strRand);
        }
        String code = randomCode.toString();
        imgCodeDO.setCode(code);
        imgCodeDO.setId(UUID.randomUUID().toString().replaceAll("-", ""));
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)buffImg, "JPEG", baos);
            byte[] bytes = baos.toByteArray();
            String data = "data:image/png;base64," + new BASE64Encoder().encodeBuffer(bytes).trim();
            data.replaceAll("\\s", "");
            imgCodeDO.setData(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CodeDO codeDO = new CodeDO(imgCodeDO.getId(), imgCodeDO.getCode());
        map.put(imgCodeDO.getId(), codeDO);
        return imgCodeDO;
    }

    private static void shear(Graphics g, int w1, int h1, Color color) {
        MyImgVerificationCodeUtils.shearX(g, w1, h1, color);
        MyImgVerificationCodeUtils.shearY(g, w1, h1, color);
    }

    private static void shearX(Graphics g, int w1, int h1, Color color) {
        int period = random.nextInt(2);
        boolean borderGap = true;
        boolean frames = true;
        int phase = random.nextInt(2);
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            if (!borderGap) continue;
            g.setColor(color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
    }

    private static void shearY(Graphics g, int w1, int h1, Color color) {
        int period = random.nextInt(40) + 10;
        boolean borderGap = true;
        int frames = 20;
        int phase = 7;
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            if (!borderGap) continue;
            g.setColor(color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }

    private static void drawRandomLines(Graphics2D g, int nums) {
        Random random = new Random();
        g.setColor(MyImgVerificationCodeUtils.getRandomColor(160, 200));
        for (int i = 0; i < nums; ++i) {
            int x = random.nextInt(width - 1);
            int y = random.nextInt(height - 1);
            int xl = random.nextInt(6) + 1;
            int yl = random.nextInt(12) + 1;
            g.drawLine(x, y, x + xl + 40, y + yl + 20);
        }
    }

    private static Color getRandomColor(int fc, int bc) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private static int getRandomNumber(int number) {
        return random.nextInt(number);
    }

    public static void overdueCleared() {
        Set<Map.Entry<String, CodeDO>> set = map.entrySet();
        for (Map.Entry<String, CodeDO> entry : set) {
            Date createTime = entry.getValue().getCreateTime();
            if (MyDateUtils.differentSecondByMillisecond(createTime, new Date()) <= expirationTime) continue;
            map.remove(entry.getKey());
        }
    }

    static {
        MyScheduleUtils.newTaskByMinutes(() -> MyImgVerificationCodeUtils.overdueCleared(), 1, true);
    }
}

