package ltd.liuzhi.rhyme.utils;


import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * 缓存工具
 * @author LiuZhi
 * @Date 2020-06-11 17:50
 * @Version V1.0
 */
public class MyCacheUtils
{
    /**
     * 该容器为了防止内存超出,只缓存1000条数据,超出则会被算法移除
     */
   private static Map<String, Object> data = new LinkedHashMap<>();

    /**
     * 缓存大小容量
     */
   private static int cacheSize = 1000;

    /**
     * 获取缓存中的值
     * @param key 缓存中的key值
     * @param tClass 需要返回的对象Class
     * @param <T> 返回的对象
     * @return 返回缓存中的对象
     */
   public static <T> T get(String key,Class<T> tClass)
   {
       return (T) data.get(key);
   }

    /**
     * 获取缓存中的值
     * @param key 缓存中的key值
     * @return 返回缓存中的对象
     */
   public static Object get(String key)
   {
       return get(key,Object.class);
   }

    /**
     * 缓存中是否存在某个key的值
     * @param key 缓存中的key值
     * @return 缓存中存在该值则true 否则false
     */
   public static boolean exist(String key)
   {
       return data.get(key) != null;
   }

    /**
     * 存储值到缓存中
     * @param key 缓存中的key值
     * @param value 需要存储的值
     */
    public static void put(String key,Object value)
    {
        put(key,value,0,null);
    }

    /**
     * 存储值到缓存中
     * @param key 缓存中的key值
     * @param value 需要存储的值
     * @param time 多少时间后过期
     * @param timeUnit 过期的时间单位
     */
    public static void put(String key, Object value, long time, TimeUnit timeUnit)
    {
        if(MyStringUtils.isEmpty(key)){
            throw new RuntimeException("缓存的key值不允许为空");
        }
        verifyTime(time,timeUnit);
        //超出大小移除首位
        if(data.size() > cacheSize)
        {
            data.entrySet().forEach(e->data.remove(e.getKey()));
        }
        data.put(key,value);
        if(time > 0 )
        {
            MyScheduleUtils.newTask(()-> data.remove(key),time,timeUnit,false);
        }

    }
    /**
     * 存储值到缓存中
     * @param key 缓存中的key值
     * @param value 需要存储的值
     * @param seconds 多少时间后过期 0 则永不过期
     */
    public static void put(String key, Object value, long seconds)
    {
       put(key,value,seconds,TimeUnit.SECONDS);
    }

    private static void verifyTime(long time, TimeUnit timeUnit)
    {
        if(time < 0)
        {
            throw new RuntimeException("非法的缓存时间,不允许小于0");
        }
        if(time > 0 && timeUnit == null)
        {
            throw new RuntimeException("缓存的时间单位不能为null");
        }
    }
}
