/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import ltd.liuzhi.rhyme.utils.MyScheduleUtils;
import ltd.liuzhi.rhyme.utils.MyStringUtils;

public class MyCacheUtils {
    private static Map<String, Object> data = new LinkedHashMap<String, Object>();
    private static int cacheSize = 1000;

    public static <T> T get(String key, Class<T> tClass) {
        return (T)data.get(key);
    }

    public static Object get(String key) {
        return MyCacheUtils.get(key, Object.class);
    }

    public static boolean exist(String key) {
        return data.get(key) != null;
    }

    public static void put(String key, Object value) {
        MyCacheUtils.put(key, value, 0L, null);
    }

    public static void put(String key, Object value, long time, TimeUnit timeUnit) {
        if (MyStringUtils.isEmpty(key).booleanValue()) {
            throw new RuntimeException("\u7f13\u5b58\u7684key\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        MyCacheUtils.verifyTime(time, timeUnit);
        if (data.size() > cacheSize) {
            data.entrySet().forEach(e -> data.remove(e.getKey()));
        }
        data.put(key, value);
        if (time > 0L) {
            MyScheduleUtils.newTask(() -> data.remove(key), time, timeUnit, false);
        }
    }

    public static void put(String key, Object value, long seconds) {
        MyCacheUtils.put(key, value, seconds, TimeUnit.SECONDS);
    }

    private static void verifyTime(long time, TimeUnit timeUnit) {
        if (time < 0L) {
            throw new RuntimeException("\u975e\u6cd5\u7684\u7f13\u5b58\u65f6\u95f4,\u4e0d\u5141\u8bb8\u5c0f\u4e8e0");
        }
        if (time > 0L && timeUnit == null) {
            throw new RuntimeException("\u7f13\u5b58\u7684\u65f6\u95f4\u5355\u4f4d\u4e0d\u80fd\u4e3anull");
        }
    }
}

