/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MyScheduleUtils {
    private static Map<Integer, RunnableScheduledFuture> map;
    private static ScheduledThreadPoolExecutor scheduledExecutorService;

    private MyScheduleUtils() {
    }

    public static Integer newTaskByMilliseconds(Runnable runnable, long milliseconds, boolean isPeriodic) {
        return MyScheduleUtils.openTask(runnable, milliseconds, TimeUnit.MILLISECONDS, isPeriodic);
    }

    public static Integer newTaskBySeconds(Runnable runnable, int seconds, boolean isPeriodic) {
        return MyScheduleUtils.openTask(runnable, seconds, TimeUnit.SECONDS, isPeriodic);
    }

    public static Integer newTask(Runnable runnable, long time, TimeUnit timeUnit, boolean isPeriodic) {
        return MyScheduleUtils.openTask(runnable, time, timeUnit, isPeriodic);
    }

    public static Integer newTaskByMinutes(Runnable runnable, int minutes, boolean isPeriodic) {
        return MyScheduleUtils.openTask(runnable, minutes, TimeUnit.MINUTES, isPeriodic);
    }

    public static Integer newTaskByHours(Runnable runnable, int hours, boolean isPeriodic) {
        return MyScheduleUtils.openTask(runnable, hours, TimeUnit.HOURS, isPeriodic);
    }

    public static synchronized boolean shutdownTask(Integer taskFlag, boolean isCloseNow) {
        if (map == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u4efb\u52a1\u6807\u8bc6");
        }
        RunnableScheduledFuture future = map.get(taskFlag);
        if (future == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u4efb\u52a1\u6807\u8bc6");
        }
        boolean result = future.cancel(isCloseNow);
        if (result) {
            map.remove(future);
            if (map.size() == 0) {
                map = null;
                scheduledExecutorService.shutdown();
                scheduledExecutorService = null;
            }
        }
        return result;
    }

    public static RunnableScheduledFuture getTaskFuture(Integer taskFlag) {
        if (map == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u4efb\u52a1\u6807\u8bc6");
        }
        RunnableScheduledFuture future = map.get(taskFlag);
        if (future == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u76f8\u5173\u7684\u4efb\u52a1\u6807\u8bc6");
        }
        return future;
    }

    public static boolean shutdownTask(Integer taskFlag) {
        return MyScheduleUtils.shutdownTask(taskFlag, false);
    }

    private static synchronized Integer openTask(Runnable runnable, long time, TimeUnit timeUnit, boolean isPeriodic) {
        if (scheduledExecutorService == null) {
            scheduledExecutorService = new ScheduledThreadPoolExecutor(5);
        }
        RunnableScheduledFuture future = isPeriodic ? (RunnableScheduledFuture)scheduledExecutorService.scheduleAtFixedRate(runnable, time, time, timeUnit) : (RunnableScheduledFuture)scheduledExecutorService.schedule(runnable, time, timeUnit);
        Integer code = future.hashCode();
        if (map == null) {
            map = new ConcurrentHashMap<Integer, RunnableScheduledFuture>();
        }
        map.put(code, future);
        return code;
    }
}

