/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.List;
import ltd.liuzhi.rhyme.utils.MyCollectionUtils;
import ltd.liuzhi.rhyme.utils.MyStringUtils;
import ltd.liuzhi.rhyme.utils.annotation.MyCSVField;

public class MyCsvExportUtils {
    private static final String CSV_COLUMN_SEPARATOR = ",";
    private static final String CSV_ROW_SEPARATOR = "\r\n";

    public static void doExport(List data, OutputStream os) {
        String str = MyCsvExportUtils.doExportString(data);
        if (str == null) {
            return;
        }
        try {
            os.write(str.getBytes("UTF-8"));
            os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String doExportString(List data) {
        Field[] fields;
        LinkedHashMap<String, MyCSVField> fieldMap = new LinkedHashMap<String, MyCSVField>();
        if (MyCollectionUtils.getSize(data) == 0) {
            return null;
        }
        Object object = data.get(0);
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            MyCSVField csvField = field.getAnnotation(MyCSVField.class);
            if (csvField == null) continue;
            fieldMap.put(field.getName(), csvField);
        }
        StringBuffer buf = new StringBuffer();
        fieldMap.entrySet().forEach(e -> buf.append("\"").append(((MyCSVField)e.getValue()).title()).append("\"").append(CSV_COLUMN_SEPARATOR));
        buf.append(CSV_ROW_SEPARATOR);
        data.forEach(d -> {
            Class<?> cls = d.getClass();
            fieldMap.entrySet().forEach(entry -> {
                String filedName = (String)entry.getKey();
                try {
                    Field field = cls.getDeclaredField(filedName);
                    field.setAccessible(true);
                    if (((MyCSVField)entry.getValue()).export()) {
                        buf.append("\"").append(MyStringUtils.isEmpty(String.valueOf(field.get(d))) != false ? ((MyCSVField)entry.getValue()).value() : String.valueOf(field.get(d))).append("\"");
                    }
                    buf.append(CSV_COLUMN_SEPARATOR);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            buf.append(CSV_ROW_SEPARATOR);
        });
        return buf.toString();
    }
}

