/*
 * Decompiled with CFR 0.152.
 */
package ltd.liuzhi.rhyme.utils;

import java.io.Serializable;

public class MyResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Integer CODE_SUCCESS = 1;
    public static final Integer CODE_FAIL = 0;
    public static final String MSG_SUCCESS = "\u64cd\u4f5c\u6210\u529f";
    public static final String MSG_FAIL = "\u64cd\u4f5c\u5931\u8d25";
    private Integer code;
    private String message;
    private T data;

    public boolean isSuccess() {
        return CODE_SUCCESS.equals(this.code);
    }

    public static <T> MyResult<T> build(Integer status, String msg, T data) {
        return new MyResult<T>(status, msg, data);
    }

    public static <T> MyResult<T> ok(T data) {
        return new MyResult<T>(data);
    }

    public static <T> MyResult<T> ok(String message, T data) {
        return new MyResult<T>(CODE_SUCCESS, message, data);
    }

    public static <T> MyResult<T> ok() {
        return new MyResult<Object>(CODE_SUCCESS, MSG_SUCCESS, null);
    }

    public static <T> MyResult<T> fail() {
        return new MyResult<Object>(CODE_FAIL, MSG_FAIL, null);
    }

    public static <T> MyResult<T> fail(String message) {
        return new MyResult<Object>(CODE_FAIL, message, null);
    }

    public static <T> MyResult<T> fail(String message, T data) {
        return new MyResult<T>(CODE_FAIL, message, data);
    }

    public static <T> MyResult<T> build(Integer status, String message) {
        return new MyResult<Object>(status, message, null);
    }

    public MyResult(Integer status, String msg, T data) {
        this.code = status;
        this.message = msg;
        this.data = data;
    }

    public MyResult(T data) {
        this.code = 0;
        this.message = MSG_SUCCESS;
        this.data = data;
    }

    public MyResult() {
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "MyResult{code=" + this.code + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }
}

