/*
 * Decompiled with CFR 0.152.
 */
package ltd.vastchain.sdk.core;

import java.util.Date;
import ltd.vastchain.sdk.core.VctcApi;
import ltd.vastchain.sdk.core.VctcApiContext;
import ltd.vastchain.sdk.exception.ErrorCode;
import ltd.vastchain.sdk.exception.VctcClientException;
import ltd.vastchain.sdk.exception.VctcException;
import ltd.vastchain.sdk.param.VctcApiCredentialParam;
import ltd.vastchain.sdk.param.VctcApiParam;
import ltd.vastchain.sdk.util.Signature;

public abstract class AbstractVctcApi
implements VctcApi {
    protected VctcApiParam apiParam;

    public AbstractVctcApi(VctcApiParam apiParam) {
        this.apiParam = apiParam;
    }

    @Override
    public <T> T request() throws VctcException {
        this.validApiParams();
        VctcApiContext context = this.buildContext();
        this.sign(context);
        return this.callApi(context);
    }

    protected String sign(VctcApiContext context) {
        String url = Signature.sign(context, new Date().getTime());
        context.setFullApiurl(url);
        return url;
    }

    private void validApiParams() throws VctcException {
        VctcApiCredentialParam credentialParam = this.apiParam.getCredentialParam();
        if (credentialParam == null) {
            throw new VctcClientException(ErrorCode.APIPARAMS_ISNULL);
        }
        if (credentialParam.getAppId() == null || "".equals(credentialParam.getAppId())) {
            throw new VctcClientException(ErrorCode.APP_ID_ISNULL);
        }
        if (credentialParam.getAppSecret() == null || "".equals(credentialParam.getAppSecret())) {
            throw new VctcClientException(ErrorCode.APP_SECRET_ISNULL);
        }
        if (credentialParam.getHostUrl() == null || "".equals(credentialParam.getHostUrl())) {
            throw new VctcClientException(ErrorCode.HOSTURL_ISNULL);
        }
        this.specialValidate();
    }

    protected abstract VctcApiContext buildContext();

    protected abstract <T> T callApi(VctcApiContext var1) throws VctcException;

    protected abstract void specialValidate() throws VctcClientException;
}

