/*
 * Decompiled with CFR 0.152.
 */
package ltd.vastchain.sdk.core.api.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import ltd.vastchain.sdk.core.AbstractVctcApi;
import ltd.vastchain.sdk.core.VctcApiContext;
import ltd.vastchain.sdk.dto.VctcApiResponseDTO;
import ltd.vastchain.sdk.enums.HttpMethodEnum;
import ltd.vastchain.sdk.enums.PayChannelEnum;
import ltd.vastchain.sdk.exception.VctcClientException;
import ltd.vastchain.sdk.exception.VctcException;
import ltd.vastchain.sdk.param.MerchantPayParam;
import ltd.vastchain.sdk.param.VctcApiParam;
import ltd.vastchain.sdk.util.OkhttpApi;

public class SetMerchantPayParamsApi
extends AbstractVctcApi {
    private final String path = "/merchant/paymentParams/";

    public SetMerchantPayParamsApi(VctcApiParam apiParam) {
        super(apiParam);
    }

    @Override
    protected void specialValidate() throws VctcClientException {
    }

    @Override
    protected VctcApiContext buildContext() {
        MerchantPayParam param = (MerchantPayParam)this.apiParam.getBuinessApiParam();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)param.getId());
        jsonObject.put("paymentChannel", (Object)param.getPaymentChannel().getCode());
        JSONObject parameters = new JSONObject();
        parameters.put("notifyCallbackUrl", (Object)param.getNotifyCallbackUrl());
        if (PayChannelEnum.WECHAT_UNIONPAYBIZSMALL == param.getPaymentChannel()) {
            parameters.put("unionPayBizMchId", (Object)param.getUnionPayBizMchId());
            parameters.put("terminalId", (Object)param.getTerminalId());
        } else if (PayChannelEnum.WECHAT_NATIVE == param.getPaymentChannel()) {
            parameters.put("profitSharing", (Object)param.getProfitSharing());
            parameters.put("wechatAppId", (Object)param.getWechatAppId());
            parameters.put("wechatMchId", (Object)param.getWechatMchId());
        }
        jsonObject.put("parameters", (Object)parameters);
        String body = jsonObject.toJSONString();
        VctcApiContext apiContext = new VctcApiContext();
        apiContext.setPath("/merchant/paymentParams/");
        apiContext.setBody(body);
        apiContext.setHttpMethod(HttpMethodEnum.PUT.getCode());
        apiContext.setCredentialParam(this.apiParam.getCredentialParam());
        return apiContext;
    }

    protected VctcApiResponseDTO callApi(VctcApiContext context) throws VctcException {
        String result = new OkhttpApi(context.getFullApiurl(), context.getCredentialParam().getTimeout()).put(context.getBody());
        return (VctcApiResponseDTO)JSON.parseObject((String)result, VctcApiResponseDTO.class);
    }
}

