/*
 * Decompiled with CFR 0.152.
 */
package ltd.vastchain.sdk.util;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import ltd.vastchain.sdk.exception.ApiResponseException;
import ltd.vastchain.sdk.exception.VctcException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkhttpApi {
    public final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private String uri;
    private Integer timeout;
    private final Integer DEFAULT_TIMEOUT = 15000;

    public OkhttpApi(String uri, Integer timeout) {
        this.uri = uri;
        if (timeout == null) {
            this.timeout = this.DEFAULT_TIMEOUT;
        }
    }

    private String call(Request request) throws VctcException {
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)this.timeout.intValue(), TimeUnit.MILLISECONDS).writeTimeout((long)this.timeout.intValue(), TimeUnit.MILLISECONDS).readTimeout((long)this.timeout.intValue(), TimeUnit.MILLISECONDS).build();
        try {
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (IOException ex) {
            throw new ApiResponseException(ex.getMessage(), ex);
        }
    }

    public String post(String bodyJson) throws VctcException {
        RequestBody body = RequestBody.create((MediaType)this.JSON_TYPE, (String)bodyJson);
        Request request = new Request.Builder().url(this.uri).post(body).build();
        return this.call(request);
    }

    public String put(String bodyJson) throws VctcException {
        RequestBody body = RequestBody.create((MediaType)this.JSON_TYPE, (String)bodyJson);
        Request request = new Request.Builder().url(this.uri).put(body).build();
        return this.call(request);
    }

    public String get() throws VctcException {
        Request request = new Request.Builder().url(this.uri).get().build();
        return this.call(request);
    }
}

