/*
 * Decompiled with CFR 0.152.
 */
package ltd.vastchain.sdk.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import ltd.vastchain.sdk.core.VctcApiContext;

public class Signature {
    public static String sign(VctcApiContext api, long time) {
        String query = api.getQuery();
        String httpMethod = api.getHttpMethod();
        String body = api.getBody();
        String appId = api.getCredentialParam().getAppId();
        String appSecret = api.getCredentialParam().getAppSecret();
        String hostUrl = api.getCredentialParam().getHostUrl();
        String path = api.getPath();
        if (query == null) {
            query = "";
        }
        String appendedQuery = "_appid=" + appId + "&_t=" + time;
        query = query.equals("") ? appendedQuery : query + "&" + appendedQuery;
        TreeMap<String, List<String>> queryList = null;
        try {
            queryList = new TreeMap<String, List<String>>(Signature.splitQuery(new URL(hostUrl + path + "?" + query)));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        String sortedQuery = "";
        String sortedEncodedQuery = "";
        for (Map.Entry<String, List<String>> entry : queryList.entrySet()) {
            if (entry.getKey().equals("_s")) break;
            if (entry.getKey().equals("_appid") && entry.getValue().size() != 1) {
                throw new IllegalArgumentException("query could not contain _appid");
            }
            if (entry.getKey().equals("_t") && entry.getValue().size() != 1) {
                throw new IllegalArgumentException("query could not contain _t");
            }
            String item = entry.getKey() + "=" + String.join((CharSequence)("&" + entry.getKey() + "="), (Iterable<? extends CharSequence>)entry.getValue());
            for (int i = 0; i < entry.getValue().size(); ++i) {
                try {
                    entry.getValue().set(i, URLEncoder.encode(entry.getValue().get(i), "UTF-8"));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            String itemEncoded = entry.getKey() + "=" + String.join((CharSequence)("&" + entry.getKey() + "="), (Iterable<? extends CharSequence>)entry.getValue());
            if (sortedQuery.equals("")) {
                sortedQuery = item;
                sortedEncodedQuery = itemEncoded;
                continue;
            }
            sortedQuery = sortedQuery + "&" + item;
            sortedEncodedQuery = sortedEncodedQuery + "&" + itemEncoded;
        }
        String toBeSignatured = (httpMethod = httpMethod.toUpperCase()).equals("POST") && body != null && !body.equals("") ? httpMethod + " " + path + "\n" + sortedQuery + "\n" + body : httpMethod + " " + path + "\n" + sortedQuery;
        String signature = Signature.HMACSHA256(toBeSignatured, appSecret);
        String url = hostUrl + path + "?" + sortedEncodedQuery + "&_s=" + signature;
        return url;
    }

    private static Map<String, List<String>> splitQuery(URL url) {
        try {
            String[] pairs;
            LinkedHashMap<String, List<String>> query_pairs = new LinkedHashMap<String, List<String>>();
            for (String pair : pairs = url.getQuery().split("&")) {
                String key;
                int idx = pair.indexOf("=");
                String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                if (!query_pairs.containsKey(key)) {
                    query_pairs.put(key, new LinkedList());
                }
                String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                ((List)query_pairs.get(key)).add(value);
            }
            return query_pairs;
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    private static String HMACSHA256(String data, String key) {
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte item : array) {
                sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString().toLowerCase();
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

