package ly.kite.instagramphotopicker;

import android.widget.BaseAdapter;

import java.util.ArrayList;
import java.util.List;


abstract class PagingBaseAdapter<T> extends BaseAdapter {

	protected List<T> items;

	public PagingBaseAdapter() {
		this.items = new ArrayList<T>();
	}

	public PagingBaseAdapter(List<T> items) {
		this.items = items;
	}

	public void addMoreItems(List<T> newItems) {
		this.items.addAll(newItems);
		notifyDataSetChanged();
	}

	public void removeAllItems() {
		this.items.clear();
		notifyDataSetChanged();
	}

    public List<T> getItems() {
        return items;
    }
}
