/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.core.runtime.spi;

import java.io.File;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import orika_shaded.org.eclipse.core.internal.registry.ExtensionRegistry;
import orika_shaded.org.eclipse.core.internal.registry.RegistryMessages;
import orika_shaded.org.eclipse.core.internal.registry.RegistrySupport;
import orika_shaded.org.eclipse.core.runtime.CoreException;
import orika_shaded.org.eclipse.core.runtime.IExtensionRegistry;
import orika_shaded.org.eclipse.core.runtime.IStatus;
import orika_shaded.org.eclipse.core.runtime.Status;
import orika_shaded.org.eclipse.core.runtime.spi.RegistryContributor;
import orika_shaded.org.eclipse.osgi.util.NLS;

public class RegistryStrategy {
    private SAXParserFactory theXMLParserFactory = null;
    private final File[] storageDirs;
    private final boolean[] cacheReadOnly;

    public RegistryStrategy(File[] storageDirs, boolean[] cacheReadOnly) {
        this.storageDirs = storageDirs;
        this.cacheReadOnly = cacheReadOnly;
    }

    public final int getLocationsLength() {
        if (this.storageDirs == null) {
            return 0;
        }
        return this.storageDirs.length;
    }

    public final File getStorage(int index) {
        if (this.storageDirs != null) {
            return this.storageDirs[index];
        }
        return null;
    }

    public final boolean isCacheReadOnly(int index) {
        if (this.cacheReadOnly != null) {
            return this.cacheReadOnly[index];
        }
        return true;
    }

    public void log(IStatus status) {
        RegistrySupport.log(status, null);
    }

    public String translate(String key, ResourceBundle resources) {
        return RegistrySupport.translate(key, resources);
    }

    public void onStart(IExtensionRegistry registry) {
    }

    public void onStop(IExtensionRegistry registry) {
    }

    public Object createExecutableExtension(RegistryContributor contributor, String className, String overridenContributorName) throws CoreException {
        Object result = null;
        Class<?> classInstance = null;
        try {
            classInstance = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            String message = NLS.bind(RegistryMessages.exExt_findClassError, contributor.getActualName(), className);
            throw new CoreException(new Status(4, "orika_shaded.org.eclipse.equinox.registry", 1, message, e1));
        }
        try {
            result = classInstance.newInstance();
        }
        catch (Exception e) {
            String message = NLS.bind(RegistryMessages.exExt_instantiateClassError, contributor.getActualName(), className);
            throw new CoreException(new Status(4, "orika_shaded.org.eclipse.equinox.registry", 1, message, e));
        }
        return result;
    }

    public void scheduleChangeEvent(Object[] listeners, Map deltas, Object registry) {
        ((ExtensionRegistry)registry).scheduleChangeEvent(listeners, deltas);
    }

    public static final IStatus processChangeEvent(Object[] listeners, Map deltas, Object registry) {
        if (registry instanceof ExtensionRegistry) {
            return ((ExtensionRegistry)registry).processChangeEvent(listeners, deltas);
        }
        return null;
    }

    public boolean debug() {
        return false;
    }

    public boolean debugRegistryEvents() {
        return false;
    }

    public boolean cacheUse() {
        return true;
    }

    public boolean cacheLazyLoading() {
        return true;
    }

    public long getContainerTimestamp() {
        return 0L;
    }

    public long getContributionsTimestamp() {
        return 0L;
    }

    public SAXParserFactory getXMLParser() {
        if (this.theXMLParserFactory == null) {
            this.theXMLParserFactory = SAXParserFactory.newInstance();
        }
        return this.theXMLParserFactory;
    }
}

