/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.core.dom;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import orika_shaded.org.eclipse.core.runtime.IProgressMonitor;
import orika_shaded.org.eclipse.jdt.core.IClassFile;
import orika_shaded.org.eclipse.jdt.core.ICompilationUnit;
import orika_shaded.org.eclipse.jdt.core.IJavaElement;
import orika_shaded.org.eclipse.jdt.core.IJavaProject;
import orika_shaded.org.eclipse.jdt.core.ITypeRoot;
import orika_shaded.org.eclipse.jdt.core.JavaCore;
import orika_shaded.org.eclipse.jdt.core.JavaModelException;
import orika_shaded.org.eclipse.jdt.core.WorkingCopyOwner;
import orika_shaded.org.eclipse.jdt.core.compiler.CategorizedProblem;
import orika_shaded.org.eclipse.jdt.core.compiler.CharOperation;
import orika_shaded.org.eclipse.jdt.core.compiler.IProblem;
import orika_shaded.org.eclipse.jdt.core.dom.AST;
import orika_shaded.org.eclipse.jdt.core.dom.ASTConverter;
import orika_shaded.org.eclipse.jdt.core.dom.ASTNode;
import orika_shaded.org.eclipse.jdt.core.dom.ASTRecoveryPropagator;
import orika_shaded.org.eclipse.jdt.core.dom.ASTRequestor;
import orika_shaded.org.eclipse.jdt.core.dom.ASTSyntaxErrorPropagator;
import orika_shaded.org.eclipse.jdt.core.dom.BindingResolver;
import orika_shaded.org.eclipse.jdt.core.dom.Block;
import orika_shaded.org.eclipse.jdt.core.dom.CompilationUnit;
import orika_shaded.org.eclipse.jdt.core.dom.CompilationUnitResolver;
import orika_shaded.org.eclipse.jdt.core.dom.DefaultBindingResolver;
import orika_shaded.org.eclipse.jdt.core.dom.Expression;
import orika_shaded.org.eclipse.jdt.core.dom.ExpressionStatement;
import orika_shaded.org.eclipse.jdt.core.dom.IBinding;
import orika_shaded.org.eclipse.jdt.core.dom.Initializer;
import orika_shaded.org.eclipse.jdt.core.dom.NodeSearcher;
import orika_shaded.org.eclipse.jdt.core.dom.Statement;
import orika_shaded.org.eclipse.jdt.core.dom.TypeDeclaration;
import orika_shaded.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import orika_shaded.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import orika_shaded.org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import orika_shaded.org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;
import orika_shaded.org.eclipse.jdt.internal.compiler.parser.RecoveryScannerData;
import orika_shaded.org.eclipse.jdt.internal.compiler.parser.Scanner;
import orika_shaded.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import orika_shaded.org.eclipse.jdt.internal.core.BasicCompilationUnit;
import orika_shaded.org.eclipse.jdt.internal.core.BinaryType;
import orika_shaded.org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import orika_shaded.org.eclipse.jdt.internal.core.PackageFragment;
import orika_shaded.org.eclipse.jdt.internal.core.util.CodeSnippetParsingUtil;
import orika_shaded.org.eclipse.jdt.internal.core.util.RecordedParsingInformation;
import orika_shaded.org.eclipse.jdt.internal.core.util.Util;

public class ASTParser {
    public static final int K_EXPRESSION = 1;
    public static final int K_STATEMENTS = 2;
    public static final int K_CLASS_BODY_DECLARATIONS = 4;
    public static final int K_COMPILATION_UNIT = 8;
    private final int apiLevel;
    private int astKind;
    private Map compilerOptions;
    private boolean resolveBindings;
    private boolean partial = false;
    private boolean statementsRecovery;
    private boolean ignoreMethodBodies;
    private boolean bindingsRecovery;
    private int focalPointPosition;
    private char[] rawSource = null;
    private ITypeRoot typeRoot = null;
    private int sourceOffset = 0;
    private int sourceLength = -1;
    private WorkingCopyOwner workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
    private IJavaProject project = null;
    private String unitName = null;

    public static ASTParser newParser(int level) {
        return new ASTParser(level);
    }

    ASTParser(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException();
        }
        this.apiLevel = level;
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.astKind = 8;
        this.rawSource = null;
        this.typeRoot = null;
        this.resolveBindings = false;
        this.ignoreMethodBodies = false;
        this.sourceLength = -1;
        this.sourceOffset = 0;
        this.workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        this.unitName = null;
        this.project = null;
        this.partial = false;
        Hashtable options = JavaCore.getOptions();
        options.remove("orika_shaded.org.eclipse.jdt.core.compiler.taskTags");
        this.compilerOptions = options;
    }

    public void setBindingsRecovery(boolean enabled) {
        this.bindingsRecovery = enabled;
    }

    public void setCompilerOptions(Map options) {
        options = options == null ? JavaCore.getOptions() : new HashMap(options);
        options.remove("orika_shaded.org.eclipse.jdt.core.compiler.taskTags");
        this.compilerOptions = options;
    }

    public void setResolveBindings(boolean bindings) {
        this.resolveBindings = bindings;
    }

    public void setFocalPosition(int position) {
        this.partial = true;
        this.focalPointPosition = position;
    }

    public void setKind(int kind) {
        if (kind != 8 && kind != 4 && kind != 1 && kind != 2) {
            throw new IllegalArgumentException();
        }
        this.astKind = kind;
    }

    public void setSource(char[] source) {
        this.rawSource = source;
        this.typeRoot = null;
    }

    public void setSource(ICompilationUnit source) {
        this.setSource((ITypeRoot)source);
    }

    public void setSource(IClassFile source) {
        this.setSource((ITypeRoot)source);
    }

    public void setSource(ITypeRoot source) {
        this.typeRoot = source;
        this.rawSource = null;
        if (source != null) {
            this.project = source.getJavaProject();
            Map options = this.project.getOptions(true);
            options.remove("orika_shaded.org.eclipse.jdt.core.compiler.taskTags");
            this.compilerOptions = options;
        }
    }

    public void setSourceRange(int offset, int length) {
        if (offset < 0 || length < -1) {
            throw new IllegalArgumentException();
        }
        this.sourceOffset = offset;
        this.sourceLength = length;
    }

    public void setStatementsRecovery(boolean enabled) {
        this.statementsRecovery = enabled;
    }

    public void setIgnoreMethodBodies(boolean enabled) {
        this.ignoreMethodBodies = true;
    }

    public void setWorkingCopyOwner(WorkingCopyOwner owner) {
        this.workingCopyOwner = owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void setProject(IJavaProject project) {
        this.project = project;
        if (project != null) {
            Map options = project.getOptions(true);
            options.remove("orika_shaded.org.eclipse.jdt.core.compiler.taskTags");
            this.compilerOptions = options;
        }
    }

    public ASTNode createAST(IProgressMonitor monitor) {
        ASTNode result = null;
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            if (this.rawSource == null && this.typeRoot == null) {
                throw new IllegalStateException("source not specified");
            }
            result = this.internalCreateAST(monitor);
        }
        finally {
            this.initializeDefaults();
            if (monitor != null) {
                monitor.done();
            }
        }
        return result;
    }

    public void createASTs(ICompilationUnit[] compilationUnits, String[] bindingKeys, ASTRequestor requestor, IProgressMonitor monitor) {
        try {
            int flags = 0;
            if (this.statementsRecovery) {
                flags |= 2;
            }
            if (this.ignoreMethodBodies) {
                flags |= 8;
            }
            if (this.resolveBindings) {
                if (this.project == null) {
                    throw new IllegalStateException("project not specified");
                }
                if (this.bindingsRecovery) {
                    flags |= 4;
                }
                CompilationUnitResolver.resolve(compilationUnits, bindingKeys, requestor, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, flags, monitor);
            } else {
                CompilationUnitResolver.parse(compilationUnits, requestor, this.apiLevel, this.compilerOptions, flags, monitor);
            }
        }
        finally {
            this.initializeDefaults();
        }
    }

    public IBinding[] createBindings(IJavaElement[] elements, IProgressMonitor monitor) {
        try {
            if (this.project == null) {
                throw new IllegalStateException("project not specified");
            }
            int flags = 0;
            if (this.statementsRecovery) {
                flags |= 2;
            }
            if (this.bindingsRecovery) {
                flags |= 4;
            }
            if (this.ignoreMethodBodies) {
                flags |= 8;
            }
            IBinding[] iBindingArray = CompilationUnitResolver.resolve(elements, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, flags, monitor);
            return iBindingArray;
        }
        finally {
            this.initializeDefaults();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ASTNode internalCreateAST(IProgressMonitor monitor) {
        boolean needToResolveBindings = this.resolveBindings;
        switch (this.astKind) {
            case 1: 
            case 2: 
            case 4: {
                if (this.rawSource == null && this.typeRoot != null) {
                    if (this.typeRoot instanceof ICompilationUnit) {
                        orika_shaded.org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = (orika_shaded.org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)this.typeRoot);
                        this.rawSource = sourceUnit.getContents();
                    } else if (this.typeRoot instanceof IClassFile) {
                        try {
                            String sourceString = this.typeRoot.getSource();
                            if (sourceString != null) {
                                this.rawSource = sourceString.toCharArray();
                            }
                        }
                        catch (JavaModelException e) {
                            StringWriter stringWriter = new StringWriter();
                            PrintWriter writer = null;
                            try {
                                writer = new PrintWriter(stringWriter);
                                e.printStackTrace(writer);
                                throw new IllegalStateException(String.valueOf(stringWriter.getBuffer()));
                            }
                            finally {
                                if (writer != null) {
                                    writer.close();
                                }
                            }
                        }
                    }
                }
                if (this.rawSource == null) throw new IllegalStateException();
                if (this.sourceOffset + this.sourceLength <= this.rawSource.length) return this.internalCreateASTForKind();
                throw new IllegalStateException();
            }
            case 8: {
                CompilationUnitDeclaration compilationUnitDeclaration = null;
                try {
                    NodeSearcher searcher = null;
                    orika_shaded.org.eclipse.jdt.internal.compiler.env.ICompilationUnit sourceUnit = null;
                    WorkingCopyOwner wcOwner = this.workingCopyOwner;
                    if (this.typeRoot instanceof ICompilationUnit) {
                        sourceUnit = (orika_shaded.org.eclipse.jdt.internal.compiler.env.ICompilationUnit)((Object)this.typeRoot);
                        sourceUnit = new BasicCompilationUnit(sourceUnit.getContents(), sourceUnit.getPackageName(), new String(sourceUnit.getFileName()), this.project);
                        wcOwner = ((ICompilationUnit)this.typeRoot).getOwner();
                    } else {
                        if (this.typeRoot instanceof IClassFile) {
                            try {
                                String sourceString = this.typeRoot.getSource();
                                if (sourceString == null) {
                                    throw new IllegalStateException();
                                }
                                PackageFragment packageFragment = (PackageFragment)this.typeRoot.getParent();
                                BinaryType type = (BinaryType)this.typeRoot.findPrimaryType();
                                IBinaryType binaryType = (IBinaryType)type.getElementInfo();
                                char[] fileName = binaryType.getFileName();
                                int firstDollar = CharOperation.indexOf('$', fileName);
                                if (firstDollar != -1) {
                                    char[] suffix = SuffixConstants.SUFFIX_class;
                                    int suffixLength = suffix.length;
                                    char[] newFileName = new char[firstDollar + suffixLength];
                                    System.arraycopy(fileName, 0, newFileName, 0, firstDollar);
                                    System.arraycopy(suffix, 0, newFileName, firstDollar, suffixLength);
                                    fileName = newFileName;
                                }
                                sourceUnit = new BasicCompilationUnit(sourceString.toCharArray(), Util.toCharArrays(packageFragment.names), new String(fileName), this.project);
                            }
                            catch (JavaModelException e) {
                                StringWriter stringWriter = new StringWriter();
                                PrintWriter writer = null;
                                try {
                                    writer = new PrintWriter(stringWriter);
                                    e.printStackTrace(writer);
                                    throw new IllegalStateException(String.valueOf(stringWriter.getBuffer()));
                                }
                                finally {
                                    if (writer != null) {
                                        writer.close();
                                    }
                                }
                            }
                        }
                        if (this.rawSource == null) throw new IllegalStateException();
                        needToResolveBindings = this.resolveBindings && this.unitName != null && this.project != null && this.compilerOptions != null;
                        sourceUnit = new BasicCompilationUnit(this.rawSource, null, this.unitName == null ? "" : this.unitName, this.project);
                    }
                    if (this.partial) {
                        searcher = new NodeSearcher(this.focalPointPosition);
                    }
                    int flags = 0;
                    if (this.statementsRecovery) {
                        flags |= 2;
                    }
                    if (searcher == null && this.ignoreMethodBodies) {
                        flags |= 8;
                    }
                    if (needToResolveBindings) {
                        if (this.bindingsRecovery) {
                            flags |= 4;
                        }
                        try {
                            compilationUnitDeclaration = CompilationUnitResolver.resolve(sourceUnit, this.project, searcher, this.compilerOptions, this.workingCopyOwner, flags, monitor);
                        }
                        catch (JavaModelException javaModelException) {
                            compilationUnitDeclaration = CompilationUnitResolver.parse(sourceUnit, searcher, this.compilerOptions, flags &= 0xFFFFFFFB);
                            needToResolveBindings = false;
                        }
                    } else {
                        compilationUnitDeclaration = CompilationUnitResolver.parse(sourceUnit, searcher, this.compilerOptions, flags);
                        needToResolveBindings = false;
                    }
                    CompilationUnit result = CompilationUnitResolver.convert(compilationUnitDeclaration, sourceUnit.getContents(), this.apiLevel, this.compilerOptions, needToResolveBindings, wcOwner, needToResolveBindings ? new DefaultBindingResolver.BindingTables() : null, flags, monitor);
                    result.setTypeRoot(this.typeRoot);
                    CompilationUnit compilationUnit = result;
                    return compilationUnit;
                }
                finally {
                    if (compilationUnitDeclaration != null && this.resolveBindings) {
                        compilationUnitDeclaration.cleanUp();
                    }
                }
            }
        }
        throw new IllegalStateException();
    }

    private ASTNode internalCreateASTForKind() {
        ASTConverter converter = new ASTConverter(this.compilerOptions, false, null);
        converter.compilationUnitSource = this.rawSource;
        converter.compilationUnitSourceLength = this.rawSource.length;
        converter.scanner.setSource(this.rawSource);
        AST ast = AST.newAST(this.apiLevel);
        ast.setDefaultNodeFlag(2);
        ast.setBindingResolver(new BindingResolver());
        if (this.statementsRecovery) {
            ast.setFlag(2);
        }
        converter.setAST(ast);
        CodeSnippetParsingUtil codeSnippetParsingUtil = new CodeSnippetParsingUtil(this.ignoreMethodBodies);
        CompilationUnit compilationUnit = ast.newCompilationUnit();
        if (this.sourceLength == -1) {
            this.sourceLength = this.rawSource.length;
        }
        switch (this.astKind) {
            case 2: {
                ConstructorDeclaration constructorDeclaration = codeSnippetParsingUtil.parseStatements(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true, this.statementsRecovery);
                RecoveryScannerData data = constructorDeclaration.compilationResult.recoveryScannerData;
                if (data != null) {
                    Scanner scanner = converter.scanner;
                    converter.docParser.scanner = converter.scanner = new RecoveryScanner(scanner, data.removeUnused());
                    converter.scanner.setSource(scanner.source);
                    compilationUnit.setStatementsRecoveryData(data);
                }
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                Block block = ast.newBlock();
                block.setSourceRange(this.sourceOffset, this.sourceOffset + this.sourceLength);
                orika_shaded.org.eclipse.jdt.internal.compiler.ast.Statement[] statements = constructorDeclaration.statements;
                if (statements != null) {
                    int statementsLength = statements.length;
                    int i = 0;
                    while (i < statementsLength) {
                        if (statements[i] instanceof LocalDeclaration) {
                            converter.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                        } else {
                            Statement statement = converter.convert(statements[i]);
                            if (statement != null) {
                                block.statements().add(statement);
                            }
                        }
                        ++i;
                    }
                }
                this.rootNodeToCompilationUnit(ast, compilationUnit, block, recordedParsingInformation, data);
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return block;
            }
            case 1: {
                orika_shaded.org.eclipse.jdt.internal.compiler.ast.Expression expression = codeSnippetParsingUtil.parseExpression(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (expression != null) {
                    Expression expression2 = converter.convert(expression);
                    this.rootNodeToCompilationUnit(expression2.getAST(), compilationUnit, expression2, codeSnippetParsingUtil.recordedParsingInformation, null);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return expression2;
                }
                IProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems(problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
            case 4: {
                orika_shaded.org.eclipse.jdt.internal.compiler.ast.ASTNode[] nodes = codeSnippetParsingUtil.parseClassBodyDeclarations(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true, this.statementsRecovery);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (nodes != null) {
                    TypeDeclaration typeDeclaration = converter.convert(nodes);
                    typeDeclaration.setSourceRange(this.sourceOffset, this.sourceOffset + this.sourceLength);
                    this.rootNodeToCompilationUnit(typeDeclaration.getAST(), compilationUnit, typeDeclaration, codeSnippetParsingUtil.recordedParsingInformation, null);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return typeDeclaration;
                }
                IProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems(problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
        }
        throw new IllegalStateException();
    }

    private void propagateErrors(ASTNode astNode, CategorizedProblem[] problems, RecoveryScannerData data) {
        astNode.accept(new ASTSyntaxErrorPropagator(problems));
        if (data != null) {
            astNode.accept(new ASTRecoveryPropagator(problems, data));
        }
    }

    private void rootNodeToCompilationUnit(AST ast, CompilationUnit compilationUnit, ASTNode node, RecordedParsingInformation recordedParsingInformation, RecoveryScannerData data) {
        int problemsCount = recordedParsingInformation.problemsCount;
        switch (node.getNodeType()) {
            case 8: {
                Block block = (Block)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(block, (CategorizedProblem[])problems, data);
                    compilationUnit.setProblems(problems);
                }
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            case 55: {
                TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(typeDeclaration, (CategorizedProblem[])problems, data);
                    compilationUnit.setProblems(problems);
                }
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            default: {
                if (!(node instanceof Expression)) break;
                Expression expression = (Expression)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(expression, (CategorizedProblem[])problems, data);
                    compilationUnit.setProblems(problems);
                }
                ExpressionStatement expressionStatement = ast.newExpressionStatement(expression);
                Block block = ast.newBlock();
                block.statements().add(expressionStatement);
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
            }
        }
    }
}

