/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core.util;

import orika_shaded.org.eclipse.jdt.core.IInitializer;
import orika_shaded.org.eclipse.jdt.core.IMember;
import orika_shaded.org.eclipse.jdt.core.ISourceRange;
import orika_shaded.org.eclipse.jdt.core.JavaModelException;
import orika_shaded.org.eclipse.jdt.core.dom.ASTNode;
import orika_shaded.org.eclipse.jdt.core.dom.ASTVisitor;
import orika_shaded.org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import orika_shaded.org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import orika_shaded.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import orika_shaded.org.eclipse.jdt.core.dom.ClassInstanceCreation;
import orika_shaded.org.eclipse.jdt.core.dom.CompilationUnit;
import orika_shaded.org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import orika_shaded.org.eclipse.jdt.core.dom.EnumDeclaration;
import orika_shaded.org.eclipse.jdt.core.dom.IBinding;
import orika_shaded.org.eclipse.jdt.core.dom.ImportDeclaration;
import orika_shaded.org.eclipse.jdt.core.dom.Initializer;
import orika_shaded.org.eclipse.jdt.core.dom.MarkerAnnotation;
import orika_shaded.org.eclipse.jdt.core.dom.MethodDeclaration;
import orika_shaded.org.eclipse.jdt.core.dom.NormalAnnotation;
import orika_shaded.org.eclipse.jdt.core.dom.PackageDeclaration;
import orika_shaded.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import orika_shaded.org.eclipse.jdt.core.dom.TypeDeclaration;
import orika_shaded.org.eclipse.jdt.core.dom.TypeParameter;
import orika_shaded.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import orika_shaded.org.eclipse.jdt.internal.core.SourceRefElement;

public class DOMFinder
extends ASTVisitor {
    public ASTNode foundNode = null;
    public IBinding foundBinding = null;
    private CompilationUnit ast;
    private SourceRefElement element;
    private boolean resolveBinding;
    private int rangeStart = -1;
    private int rangeLength = 0;

    public DOMFinder(CompilationUnit ast, SourceRefElement element, boolean resolveBinding) {
        this.ast = ast;
        this.element = element;
        this.resolveBinding = resolveBinding;
    }

    protected boolean found(ASTNode node, ASTNode name) {
        if (name.getStartPosition() == this.rangeStart && name.getLength() == this.rangeLength) {
            this.foundNode = node;
            return true;
        }
        return false;
    }

    public ASTNode search() throws JavaModelException {
        ISourceRange range = null;
        range = this.element instanceof IMember && !(this.element instanceof IInitializer) ? ((IMember)((Object)this.element)).getNameRange() : this.element.getSourceRange();
        this.rangeStart = range.getOffset();
        this.rangeLength = range.getLength();
        this.ast.accept(this);
        return this.foundNode;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        ASTNode name;
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 14: {
                name = ((ClassInstanceCreation)parent).getType();
                break;
            }
            case 72: {
                name = ((EnumConstantDeclaration)parent).getName();
                break;
            }
            default: {
                return true;
            }
        }
        if (this.found(node, name) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(EnumConstantDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveVariable();
        }
        return true;
    }

    public boolean visit(EnumDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(Initializer node) {
        this.found(node, node);
        return true;
    }

    public boolean visit(MarkerAnnotation node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveAnnotationBinding();
        }
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(NormalAnnotation node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveAnnotationBinding();
        }
        return true;
    }

    public boolean visit(PackageDeclaration node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(SingleMemberAnnotation node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveAnnotationBinding();
        }
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(TypeParameter node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }
}

