/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.core.internal.registry.osgi;

import orika_shaded.org.eclipse.core.runtime.IConfigurationElement;
import orika_shaded.org.eclipse.core.runtime.IExtension;
import orika_shaded.org.eclipse.core.runtime.IExtensionPoint;
import orika_shaded.org.eclipse.core.runtime.IExtensionRegistry;
import orika_shaded.org.eclipse.core.runtime.RegistryFactory;
import orika_shaded.org.eclipse.osgi.framework.console.CommandInterpreter;
import orika_shaded.org.eclipse.osgi.framework.console.CommandProvider;

public class RegistryCommandProvider
implements CommandProvider {
    private static final String helpText = "---Extension Registry Commands---\n\tns [-v] [name] - display extension points in the namespace; add -v to display extensions\n\tpt [-v] uniqueExtensionPointId - display the extension point and extensions; add -v to display config elements";
    private static final String indent = "   ";
    private boolean verbose = false;

    public String getHelp() {
        return helpText;
    }

    public void _ns(CommandInterpreter ci) throws Exception {
        String namespace = this.getArgument(ci);
        if (namespace == null) {
            String[] namespaces = RegistryFactory.getRegistry().getNamespaces();
            ci.println("Namespace(s):");
            ci.println("-------------------");
            int i = 0;
            while (i < namespaces.length) {
                ci.println(namespaces[i]);
                ++i;
            }
            return;
        }
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint[] extpts = registry.getExtensionPoints(namespace);
        ci.println("Extension point(s):");
        ci.println("-------------------");
        int i = 0;
        while (i < extpts.length) {
            this.displayExtensionPoint(extpts[i], ci);
            ++i;
        }
        if (this.verbose) {
            ci.println("\nExtension(s):");
            ci.println("-------------------");
            IExtension[] exts = RegistryFactory.getRegistry().getExtensions(namespace);
            int j = 0;
            while (j < exts.length) {
                this.displayExtension(exts[j], ci, true);
                ++j;
            }
        }
    }

    public void _pt(CommandInterpreter ci) throws Exception {
        String extensionPointId = this.getArgument(ci);
        if (extensionPointId == null) {
            return;
        }
        IExtensionPoint extpt = RegistryFactory.getRegistry().getExtensionPoint(extensionPointId);
        if (extpt == null) {
            return;
        }
        ci.print("Extension point: ");
        this.displayExtensionPoint(extpt, ci);
        IExtension[] exts = extpt.getExtensions();
        ci.println("\nExtension(s):");
        ci.println("-------------------");
        int i = 0;
        while (i < exts.length) {
            this.displayExtension(exts[i], ci, false);
            if (this.verbose) {
                IConfigurationElement[] ce = exts[i].getConfigurationElements();
                int j = 0;
                while (j < ce.length) {
                    this.displayConfigElement(ci, ce[j], 1);
                    ++j;
                }
                ci.println();
            }
            ++i;
        }
    }

    private String getArgument(CommandInterpreter ci) {
        String firstParm = ci.nextArgument();
        if ("-v".equals(firstParm)) {
            this.verbose = true;
            return ci.nextArgument();
        }
        this.verbose = false;
        return firstParm;
    }

    private void displayExtensionPoint(IExtensionPoint extentionPoint, CommandInterpreter ci) {
        if (extentionPoint == null) {
            return;
        }
        ci.println(String.valueOf(extentionPoint.getUniqueIdentifier()) + " [from " + extentionPoint.getContributor().getName() + ']');
    }

    private void displayExtension(IExtension extention, CommandInterpreter ci, boolean full) {
        if (extention == null) {
            return;
        }
        if (full) {
            ci.print("Id: " + extention.getUniqueIdentifier());
            ci.print(" PointId: " + extention.getExtensionPointUniqueIdentifier());
            ci.println(" [from " + extention.getContributor().getName() + "]");
        } else {
            ci.println(String.valueOf(extention.getUniqueIdentifier()) + " [from " + extention.getContributor().getName() + "]");
        }
    }

    private void displayConfigElement(CommandInterpreter ci, IConfigurationElement ce, int level) throws Exception {
        String spacing = this.spacing(ci, level);
        ci.println(String.valueOf(spacing) + '<' + ce.getName() + '>');
        String[] attrs = ce.getAttributeNames();
        int k = 0;
        while (k < attrs.length) {
            ci.println(indent + spacing + attrs[k] + " = " + ce.getAttribute(attrs[k]));
            ++k;
        }
        String value = ce.getValue();
        if (value != null) {
            ci.println(indent + spacing + value);
        }
        IConfigurationElement[] children = ce.getChildren();
        int z = 0;
        while (z < children.length) {
            this.displayConfigElement(ci, children[z], level + 1);
            ++z;
        }
        ci.println(String.valueOf(spacing) + "</" + ce.getName() + '>');
    }

    private String spacing(CommandInterpreter ci, int level) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < level) {
            b.append(indent);
            ++i;
        }
        return b.toString();
    }
}

