/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import orika_shaded.org.eclipse.core.resources.IContainer;
import orika_shaded.org.eclipse.core.resources.IFolder;
import orika_shaded.org.eclipse.core.resources.IResource;
import orika_shaded.org.eclipse.core.runtime.IPath;
import orika_shaded.org.eclipse.core.runtime.Path;
import orika_shaded.org.eclipse.core.runtime.jobs.ISchedulingRule;
import orika_shaded.org.eclipse.jdt.core.IJavaElement;
import orika_shaded.org.eclipse.jdt.core.IJavaModelStatus;
import orika_shaded.org.eclipse.jdt.core.IJavaProject;
import orika_shaded.org.eclipse.jdt.core.IPackageFragmentRoot;
import orika_shaded.org.eclipse.jdt.core.JavaConventions;
import orika_shaded.org.eclipse.jdt.core.JavaModelException;
import orika_shaded.org.eclipse.jdt.core.compiler.CharOperation;
import orika_shaded.org.eclipse.jdt.internal.core.JavaElement;
import orika_shaded.org.eclipse.jdt.internal.core.JavaElementDelta;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelOperation;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelStatus;
import orika_shaded.org.eclipse.jdt.internal.core.PackageFragment;
import orika_shaded.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import orika_shaded.org.eclipse.jdt.internal.core.util.Messages;
import orika_shaded.org.eclipse.jdt.internal.core.util.Util;

public class CreatePackageFragmentOperation
extends JavaModelOperation {
    protected String[] pkgName;

    public CreatePackageFragmentOperation(IPackageFragmentRoot parentElement, String packageName, boolean force) {
        super(null, new IJavaElement[]{parentElement}, force);
        this.pkgName = packageName == null ? null : Util.getTrimmedSimpleNames(packageName);
    }

    protected void executeOperation() throws JavaModelException {
        try {
            JavaElementDelta delta = null;
            PackageFragmentRoot root = (PackageFragmentRoot)this.getParentElement();
            this.beginTask(Messages.operation_createPackageFragmentProgress, this.pkgName.length);
            IContainer parentFolder = (IContainer)root.resource();
            String[] sideEffectPackageName = CharOperation.NO_STRINGS;
            ArrayList<PackageFragment> results = new ArrayList<PackageFragment>(this.pkgName.length);
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            char[][] exclusionPatterns = root.fullExclusionPatternChars();
            int i = 0;
            while (i < this.pkgName.length) {
                String subFolderName = this.pkgName[i];
                sideEffectPackageName = Util.arrayConcat(sideEffectPackageName, subFolderName);
                IResource subFolder = parentFolder.findMember(subFolderName);
                if (subFolder == null) {
                    this.createFolder(parentFolder, subFolderName, this.force);
                    parentFolder = parentFolder.getFolder((IPath)new Path(subFolderName));
                    PackageFragment addedFrag = root.getPackageFragment(sideEffectPackageName);
                    if (!Util.isExcluded((IResource)parentFolder, inclusionPatterns, exclusionPatterns)) {
                        if (delta == null) {
                            delta = this.newJavaElementDelta();
                        }
                        delta.added(addedFrag);
                    }
                    results.add(addedFrag);
                } else {
                    parentFolder = (IContainer)subFolder;
                }
                this.worked(1);
                ++i;
            }
            if (results.size() > 0) {
                this.resultElements = new IJavaElement[results.size()];
                results.toArray(this.resultElements);
                if (delta != null) {
                    this.addDelta(delta);
                }
            }
        }
        finally {
            this.done();
        }
    }

    protected ISchedulingRule getSchedulingRule() {
        if (this.pkgName.length == 0) {
            return null;
        }
        IResource parentResource = ((JavaElement)this.getParentElement()).resource();
        IFolder resource = ((IContainer)parentResource).getFolder((IPath)new Path(this.pkgName[0]));
        return resource.getWorkspace().getRuleFactory().createRule((IResource)resource);
    }

    public IJavaModelStatus verify() {
        IJavaElement parentElement = this.getParentElement();
        if (parentElement == null) {
            return new JavaModelStatus(968);
        }
        String packageName = this.pkgName == null ? null : Util.concatWith(this.pkgName, '.');
        IJavaProject project = parentElement.getJavaProject();
        if (this.pkgName == null || this.pkgName.length > 0 && JavaConventions.validatePackageName(packageName, project.getOption("orika_shaded.org.eclipse.jdt.core.compiler.source", true), project.getOption("orika_shaded.org.eclipse.jdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, packageName);
        }
        IJavaElement root = this.getParentElement();
        if (root.isReadOnly()) {
            return new JavaModelStatus(976, root);
        }
        IContainer parentFolder = (IContainer)((JavaElement)root).resource();
        int i = 0;
        while (i < this.pkgName.length) {
            IResource subFolder = parentFolder.findMember(this.pkgName[i]);
            if (subFolder != null) {
                if (subFolder.getType() != 2) {
                    return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, subFolder.getFullPath().toString()));
                }
                parentFolder = (IContainer)subFolder;
            }
            ++i;
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

