/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core.search;

import orika_shaded.org.eclipse.core.runtime.CoreException;
import orika_shaded.org.eclipse.core.runtime.IPath;
import orika_shaded.org.eclipse.core.runtime.IProgressMonitor;
import orika_shaded.org.eclipse.core.runtime.OperationCanceledException;
import orika_shaded.org.eclipse.jdt.core.search.IJavaSearchScope;
import orika_shaded.org.eclipse.jdt.core.search.SearchDocument;
import orika_shaded.org.eclipse.jdt.core.search.SearchParticipant;
import orika_shaded.org.eclipse.jdt.core.search.SearchPattern;
import orika_shaded.org.eclipse.jdt.core.search.SearchRequestor;
import orika_shaded.org.eclipse.jdt.internal.core.search.IndexSelector;
import orika_shaded.org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import orika_shaded.org.eclipse.jdt.internal.core.search.indexing.BinaryIndexer;
import orika_shaded.org.eclipse.jdt.internal.core.search.indexing.SourceIndexer;
import orika_shaded.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import orika_shaded.org.eclipse.jdt.internal.core.util.Util;

public class JavaSearchParticipant
extends SearchParticipant {
    private ThreadLocal indexSelector = new ThreadLocal();

    public void beginSearching() {
        super.beginSearching();
        this.indexSelector.set(null);
    }

    public void doneSearching() {
        this.indexSelector.set(null);
        super.doneSearching();
    }

    public String getDescription() {
        return "Java";
    }

    public SearchDocument getDocument(String documentPath) {
        return new JavaSearchDocument(documentPath, this);
    }

    public void indexDocument(SearchDocument document, IPath indexPath) {
        document.removeAllIndexEntries();
        String documentPath = document.getPath();
        if (Util.isJavaLikeFileName(documentPath)) {
            new SourceIndexer(document).indexDocument();
        } else if (orika_shaded.org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(documentPath)) {
            new BinaryIndexer(document).indexDocument();
        }
    }

    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        MatchLocator matchLocator = new MatchLocator(pattern, requestor, scope, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locateMatches(indexMatches);
    }

    public IPath[] selectIndexes(SearchPattern pattern, IJavaSearchScope scope) {
        IndexSelector selector = (IndexSelector)this.indexSelector.get();
        if (selector == null) {
            selector = new IndexSelector(scope, pattern);
            this.indexSelector.set(selector);
        }
        return selector.getIndexLocations();
    }
}

