/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.formatter.comment;

import java.util.Iterator;
import java.util.LinkedList;
import orika_shaded.org.eclipse.core.runtime.Assert;
import orika_shaded.org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import orika_shaded.org.eclipse.jdt.internal.formatter.CodeFormatterVisitor;
import orika_shaded.org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import orika_shaded.org.eclipse.jdt.internal.formatter.Scribe;
import orika_shaded.org.eclipse.jdt.internal.formatter.comment.CommentFormatterUtil;
import orika_shaded.org.eclipse.jdt.internal.formatter.comment.CommentLine;
import orika_shaded.org.eclipse.jdt.internal.formatter.comment.CommentRange;
import orika_shaded.org.eclipse.jdt.internal.formatter.comment.IBorderAttributes;
import orika_shaded.org.eclipse.jdt.internal.formatter.comment.ICommentAttributes;
import orika_shaded.org.eclipse.jdt.internal.formatter.comment.IHtmlTagDelimiters;
import orika_shaded.org.eclipse.jdt.internal.formatter.comment.SingleCommentLine;
import orika_shaded.org.eclipse.jface.text.BadLocationException;
import orika_shaded.org.eclipse.jface.text.DefaultLineTracker;
import orika_shaded.org.eclipse.jface.text.IDocument;
import orika_shaded.org.eclipse.jface.text.IRegion;
import orika_shaded.org.eclipse.jface.text.Position;
import orika_shaded.org.eclipse.text.edits.MalformedTreeException;
import orika_shaded.org.eclipse.text.edits.TextEdit;

public class CommentRegion
extends Position
implements IHtmlTagDelimiters,
IBorderAttributes,
ICommentAttributes {
    protected static final String COMMENT_RANGE_DELIMITER = " ";
    private static final int COMMENT_PREFIX_LENGTH = 3;
    private int fBorders = 0;
    protected boolean fClear;
    private final String fDelimiter;
    private final IDocument fDocument;
    private final LinkedList fLines = new LinkedList();
    protected final DefaultCodeFormatterOptions preferences;
    private final LinkedList fRanges = new LinkedList();
    private final boolean fSingleLine;
    private int fTabSize;
    protected Scribe scribe;

    public CommentRegion(IDocument document, Position position, CodeFormatterVisitor formatter) {
        super(position.getOffset(), position.getLength());
        this.preferences = formatter.preferences;
        this.fDelimiter = this.preferences.line_separator;
        this.fDocument = document;
        this.fTabSize = 2 == this.preferences.tab_char ? this.preferences.indentation_size : this.preferences.tab_size;
        this.scribe = formatter.scribe;
        DefaultLineTracker tracker = new DefaultLineTracker();
        IRegion range = null;
        CommentLine line = null;
        tracker.set(this.getText(0, this.getLength()));
        int lines = tracker.getNumberOfLines();
        this.fSingleLine = lines == 1;
        try {
            int index = 0;
            while (index < lines) {
                range = tracker.getLineInformation(index);
                line = this.createLine();
                line.append(new CommentRange(range.getOffset(), range.getLength()));
                this.fLines.add(line);
                ++index;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected final void append(CommentRange range) {
        this.fRanges.addLast(range);
    }

    protected boolean canAppend(CommentLine line, CommentRange previous, CommentRange next, int index, int width) {
        return index == 0 || index + next.getLength() <= width;
    }

    protected boolean canFormat(CommentRange previous, CommentRange next) {
        return previous != null;
    }

    public final TextEdit format(int indentationLevel, boolean returnEdit) {
        String probe = this.getText(0, "/*-".length());
        if (!probe.startsWith("/*-")) {
            int margin = this.preferences.comment_line_length;
            String indentation = this.computeIndentation(indentationLevel);
            margin = Math.max(4, margin - this.stringToLength(indentation) - 3);
            this.tokenizeRegion();
            this.markRegion();
            this.wrapRegion(margin);
            this.formatRegion(indentation, margin);
        }
        if (returnEdit) {
            return this.scribe.getRootEdit();
        }
        return null;
    }

    protected void formatRegion(String indentation, int width) {
        int last = this.fLines.size() - 1;
        if (last >= 0) {
            CommentLine lastLine = (CommentLine)this.fLines.get(last);
            CommentRange lastRange = lastLine.getLast();
            lastLine.formatLowerBorder(lastRange, indentation, width);
            CommentLine next = null;
            CommentRange range = null;
            int line = last;
            while (line >= 0) {
                CommentLine previous = next;
                next = (CommentLine)this.fLines.get(line);
                range = next.formatLine(previous, range, indentation, line);
                --line;
            }
            next.formatUpperBorder(range, indentation, width);
        }
    }

    protected final String getDelimiter() {
        return this.fDelimiter;
    }

    protected String getDelimiter(CommentLine predecessor, CommentLine successor, CommentRange previous, CommentRange next, String indentation) {
        return String.valueOf(this.fDelimiter) + indentation + successor.getContentPrefix();
    }

    protected String getDelimiter(CommentRange previous, CommentRange next) {
        return COMMENT_RANGE_DELIMITER;
    }

    protected final IDocument getDocument() {
        return this.fDocument;
    }

    protected final LinkedList getRanges() {
        return this.fRanges;
    }

    protected final int getSize() {
        return this.fLines.size();
    }

    protected final String getText(int position, int count) {
        String content = "";
        try {
            content = this.fDocument.get(this.getOffset() + position, count);
        }
        catch (BadLocationException badLocationException) {}
        return content;
    }

    protected final boolean hasBorder(int border) {
        return (this.fBorders & border) == border;
    }

    protected final boolean isAlphaNumeric(CommentRange range) {
        String token = this.getText(range.getOffset(), range.getLength());
        int index = 0;
        while (index < token.length()) {
            if (!ScannerHelper.isLetterOrDigit(token.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected final boolean isNonAlphaNumeric(CommentRange range) {
        String token = this.getText(range.getOffset(), range.getLength());
        int index = 0;
        while (index < token.length()) {
            if (ScannerHelper.isLetterOrDigit(token.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected final boolean isClearLines() {
        return this.fClear;
    }

    protected final boolean isSingleLine() {
        return this.fSingleLine;
    }

    protected final void logEdit(String change, int position, int count) {
        try {
            int base = this.getOffset() + position;
            String content = this.fDocument.get(base, count);
            if (!change.equals(content)) {
                if (count > 0) {
                    this.scribe.addReplaceEdit(base, base + count - 1, change);
                } else {
                    this.scribe.addInsertEdit(base, change);
                }
            }
        }
        catch (BadLocationException exception) {
            CommentFormatterUtil.log(exception);
        }
        catch (MalformedTreeException exception) {
            CommentFormatterUtil.log(exception);
        }
    }

    protected void markRegion() {
    }

    protected final void setBorder(int border) {
        this.fBorders |= border;
    }

    private String computeIndentation(int indentationLevel) {
        if (1 == this.preferences.tab_char) {
            return this.replicate("\t", indentationLevel);
        }
        if (2 == this.preferences.tab_char) {
            return this.replicate(COMMENT_RANGE_DELIMITER, indentationLevel * this.preferences.tab_size);
        }
        if (4 == this.preferences.tab_char) {
            int tabSize = this.preferences.tab_size;
            int indentSize = this.preferences.indentation_size;
            int spaceEquivalents = indentationLevel * indentSize;
            return String.valueOf(this.replicate("\t", spaceEquivalents / tabSize)) + this.replicate(COMMENT_RANGE_DELIMITER, spaceEquivalents % tabSize);
        }
        Assert.isTrue(false);
        return null;
    }

    private String replicate(String string, int n) {
        StringBuffer buffer = new StringBuffer(n * string.length());
        int i = 0;
        while (i < n) {
            buffer.append(string);
            ++i;
        }
        return buffer.toString();
    }

    protected final String stringToIndent(String reference) {
        return this.replicate(COMMENT_RANGE_DELIMITER, this.stringToLength(reference));
    }

    protected final int stringToLength(String reference) {
        return this.expandTabs(reference).length();
    }

    private String expandTabs(String string) {
        StringBuffer expanded = new StringBuffer();
        int i = 0;
        int n = string.length();
        int chars = 0;
        while (i < n) {
            char ch = string.charAt(i);
            if (ch == '\t') {
                while (chars < this.fTabSize) {
                    expanded.append(' ');
                    ++chars;
                }
                chars = 0;
            } else {
                expanded.append(ch);
                if (++chars >= this.fTabSize) {
                    chars = 0;
                }
            }
            ++i;
        }
        return expanded.toString();
    }

    protected void tokenizeRegion() {
        int index = 0;
        CommentLine line = null;
        Iterator iterator = this.fLines.iterator();
        while (iterator.hasNext()) {
            line = (CommentLine)iterator.next();
            line.scanLine(index);
            line.tokenizeLine(index);
            ++index;
        }
    }

    protected void wrapRegion(int width) {
        this.fLines.clear();
        int index = 0;
        boolean adapted = false;
        CommentLine successor = null;
        CommentLine predecessor = null;
        CommentRange previous = null;
        CommentRange next = null;
        block0: while (!this.fRanges.isEmpty()) {
            index = 0;
            adapted = false;
            predecessor = successor;
            successor = this.createLine();
            this.fLines.add(successor);
            while (!this.fRanges.isEmpty()) {
                next = (CommentRange)this.fRanges.getFirst();
                if (!this.canAppend(successor, previous, next, index, width)) continue block0;
                if (!adapted && predecessor != null) {
                    successor.adapt(predecessor);
                    adapted = true;
                }
                this.fRanges.removeFirst();
                successor.append(next);
                index += next.getLength() + 1;
                previous = next;
            }
        }
    }

    protected CommentLine createLine() {
        return new SingleCommentLine(this);
    }
}

