/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.osgi.framework.debug;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import orika_shaded.org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import orika_shaded.org.eclipse.osgi.service.debug.DebugOptions;

public class FrameworkDebugOptions
implements DebugOptions {
    private Properties options = null;
    private static FrameworkDebugOptions singleton = null;
    private static boolean debugEnabled = true;
    private static final String OPTIONS = ".options";

    public static FrameworkDebugOptions getDefault() {
        FrameworkDebugOptions result;
        if (singleton == null && debugEnabled && (debugEnabled = (result = new FrameworkDebugOptions()).isDebugEnabled())) {
            singleton = result;
        }
        return singleton;
    }

    private static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        boolean isFile = spec.startsWith("file:");
        try {
            if (isFile) {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(spec.substring(5)).toURL(), trailingSlash);
            }
            return new URL(spec);
        }
        catch (MalformedURLException malformedURLException) {
            if (isFile) {
                return null;
            }
            try {
                return FrameworkDebugOptions.adjustTrailingSlash(new File(spec).toURL(), trailingSlash);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getFile();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? String.valueOf(file) + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    private FrameworkDebugOptions() {
        this.loadOptions();
    }

    public boolean getBooleanOption(String option, boolean defaultValue) {
        String optionValue = this.getOption(option);
        return optionValue != null && optionValue.equalsIgnoreCase("true") || defaultValue;
    }

    public String getOption(String option) {
        return this.options != null ? this.options.getProperty(option) : null;
    }

    public String getOption(String option, String defaultValue) {
        return this.options != null ? this.options.getProperty(option, defaultValue) : defaultValue;
    }

    public int getIntegerOption(String option, int defaultValue) {
        String value = this.getOption(option);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public void setOption(String option, String value) {
        if (this.options != null) {
            this.options.put(option, value.trim());
        }
    }

    private boolean isDebugEnabled() {
        return this.options != null;
    }

    private void loadOptions() {
        URL optionsFile;
        String debugOptionsFilename = FrameworkProperties.getProperty("osgi.debug");
        if (debugOptionsFilename == null) {
            return;
        }
        this.options = new Properties();
        if (debugOptionsFilename.length() == 0) {
            String userDir = FrameworkProperties.getProperty("user.dir").replace(File.separatorChar, '/');
            if (!userDir.endsWith("/")) {
                userDir = String.valueOf(userDir) + "/";
            }
            debugOptionsFilename = new File(userDir, OPTIONS).toString();
        }
        if ((optionsFile = FrameworkDebugOptions.buildURL(debugOptionsFilename, false)) == null) {
            System.out.println("Unable to construct URL for options file: " + debugOptionsFilename);
            return;
        }
        System.out.print("Debug options:\n    " + optionsFile.toExternalForm());
        try {
            InputStream input = optionsFile.openStream();
            try {
                this.options.load(input);
                System.out.println(" loaded");
            }
            finally {
                input.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(" not found");
        }
        catch (IOException e) {
            System.out.println(" did not parse");
            e.printStackTrace(System.out);
        }
        Iterator<Object> i = this.options.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            this.options.put(key, ((String)this.options.get(key)).trim());
        }
        if (this.options.size() == 0) {
            this.options = null;
        }
    }
}

