/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import orika_shaded.org.eclipse.osgi.framework.internal.core.BundleLoader;
import orika_shaded.org.eclipse.osgi.framework.internal.core.BundleLoaderProxy;
import orika_shaded.org.eclipse.osgi.framework.internal.core.IBuddyPolicy;
import orika_shaded.org.eclipse.osgi.service.resolver.BundleDescription;

public class DependentPolicy
implements IBuddyPolicy {
    BundleLoader buddyRequester;
    int lastDependentOfAdded = -1;
    List allDependents = null;

    public DependentPolicy(BundleLoader requester) {
        this.buddyRequester = requester;
        this.allDependents = new ArrayList();
        this.basicAddImmediateDependents(this.buddyRequester.getBundle().getBundleDescription());
        if (this.allDependents.size() == 0) {
            this.allDependents = null;
        }
    }

    public Class loadClass(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Class result = null;
        int i = 0;
        while (i < this.allDependents.size() && result == null) {
            block5: {
                BundleDescription searchedBundle = (BundleDescription)this.allDependents.get(i);
                try {
                    BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy(searchedBundle);
                    if (proxy != null) {
                        result = proxy.getBundleLoader().findClass(name, true);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (result != null) break block5;
                    this.addDependent(i, searchedBundle);
                }
            }
            ++i;
        }
        return result;
    }

    private synchronized void addDependent(int i, BundleDescription searchedBundle) {
        if (i > this.lastDependentOfAdded) {
            this.lastDependentOfAdded = i;
            this.basicAddImmediateDependents(searchedBundle);
        }
    }

    public URL loadResource(String name) {
        if (this.allDependents == null) {
            return null;
        }
        URL result = null;
        int i = 0;
        while (i < this.allDependents.size() && result == null) {
            BundleDescription searchedBundle = (BundleDescription)this.allDependents.get(i);
            BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy(searchedBundle);
            if (proxy != null && (result = proxy.getBundleLoader().findResource(name, true)) == null) {
                this.addDependent(i, searchedBundle);
            }
            ++i;
        }
        return result;
    }

    public Enumeration loadResources(String name) {
        if (this.allDependents == null) {
            return null;
        }
        Enumeration results = null;
        int i = 0;
        while (i < this.allDependents.size()) {
            BundleDescription searchedBundle = (BundleDescription)this.allDependents.get(i);
            try {
                BundleLoaderProxy proxy = this.buddyRequester.getLoaderProxy(searchedBundle);
                if (proxy != null) {
                    results = BundleLoader.compoundEnumerations(results, proxy.getBundleLoader().findResources(name));
                    this.addDependent(i, searchedBundle);
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        return results;
    }

    private void basicAddImmediateDependents(BundleDescription root) {
        BundleDescription[] dependents = root.getDependents();
        int i = 0;
        while (i < dependents.length) {
            BundleDescription toAdd = dependents[i];
            if (toAdd.getHost() == null && !this.allDependents.contains(toAdd)) {
                this.allDependents.add(toAdd);
            }
            ++i;
        }
    }
}

