/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.osgi.framework.internal.core;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import orika_shaded.org.eclipse.osgi.framework.internal.core.BundleLoader;
import orika_shaded.org.eclipse.osgi.framework.internal.core.DependentPolicy;
import orika_shaded.org.eclipse.osgi.framework.internal.core.GlobalPolicy;
import orika_shaded.org.eclipse.osgi.framework.internal.core.IBuddyPolicy;
import orika_shaded.org.eclipse.osgi.framework.internal.core.RegisteredPolicy;
import orika_shaded.org.eclipse.osgi.framework.internal.core.SystemPolicy;

public class PolicyHandler {
    private static final String DEPENDENT_POLICY = "dependent";
    private static final String GLOBAL_POLICY = "global";
    private static final String REGISTERED_POLICY = "registered";
    private static final String APP_POLICY = "app";
    private static final String EXT_POLICY = "ext";
    private static final String BOOT_POLICY = "boot";
    private static final String PARENT_POLICY = "parent";
    BundleLoader policedLoader;
    Object[] policies = null;
    private ThreadLocal beingLoaded;
    private BundleListener listener = new BundleListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            if (event.getType() == 2 || event.getType() == 4) {
                return;
            }
            try {
                String list = (String)PolicyHandler.this.policedLoader.getBundle().getBundleData().getManifest().get("Eclipse-BuddyPolicy");
                1 var3_3 = this;
                synchronized (var3_3) {
                    PolicyHandler.this.policies = PolicyHandler.getArrayFromList(list);
                }
            }
            catch (BundleException bundleException) {}
        }
    };

    public PolicyHandler(BundleLoader loader, String buddyList) {
        this.policedLoader = loader;
        this.policies = PolicyHandler.getArrayFromList(buddyList);
        this.beingLoaded = new ThreadLocal();
        this.policedLoader.bundle.framework.systemBundle.context.addBundleListener(this.listener);
    }

    static Object[] getArrayFromList(String stringList) {
        if (stringList == null || stringList.trim().equals("")) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(stringList, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new Object[]{} : list.toArray(new Object[list.size()]);
    }

    private synchronized IBuddyPolicy getPolicyImplementation(int policyOrder) {
        if (this.policies[policyOrder] instanceof String) {
            String buddyName = (String)this.policies[policyOrder];
            if (REGISTERED_POLICY.equals(buddyName)) {
                this.policies[policyOrder] = new RegisteredPolicy(this.policedLoader);
                return (IBuddyPolicy)this.policies[policyOrder];
            }
            if (BOOT_POLICY.equals(buddyName)) {
                this.policies[policyOrder] = SystemPolicy.getInstance((byte)0);
                return (IBuddyPolicy)this.policies[policyOrder];
            }
            if (APP_POLICY.equals(buddyName)) {
                this.policies[policyOrder] = SystemPolicy.getInstance((byte)2);
                return (IBuddyPolicy)this.policies[policyOrder];
            }
            if (EXT_POLICY.equals(buddyName)) {
                this.policies[policyOrder] = SystemPolicy.getInstance((byte)1);
                return (IBuddyPolicy)this.policies[policyOrder];
            }
            if (DEPENDENT_POLICY.equals(buddyName)) {
                this.policies[policyOrder] = new DependentPolicy(this.policedLoader);
                return (IBuddyPolicy)this.policies[policyOrder];
            }
            if (GLOBAL_POLICY.equals(buddyName)) {
                this.policies[policyOrder] = new GlobalPolicy(this.policedLoader.bundle.framework.packageAdmin);
                return (IBuddyPolicy)this.policies[policyOrder];
            }
            if (PARENT_POLICY.equals(buddyName)) {
                this.policies[policyOrder] = new SystemPolicy(this.policedLoader.getParentClassLoader());
                return (IBuddyPolicy)this.policies[policyOrder];
            }
        }
        return (IBuddyPolicy)this.policies[policyOrder];
    }

    public Class doBuddyClassLoading(String name) {
        if (!this.startLoading(name)) {
            return null;
        }
        Class result = null;
        int i = 0;
        while (i < this.policies.length && result == null) {
            result = this.getPolicyImplementation(i).loadClass(name);
            ++i;
        }
        this.stopLoading(name);
        return result;
    }

    public URL doBuddyResourceLoading(String name) {
        if (!this.startLoading(name)) {
            return null;
        }
        if (this.policies == null) {
            return null;
        }
        URL result = null;
        int i = 0;
        while (i < this.policies.length && result == null) {
            result = this.getPolicyImplementation(i).loadResource(name);
            ++i;
        }
        this.stopLoading(name);
        return result;
    }

    public Enumeration doBuddyResourcesLoading(String name) {
        if (!this.startLoading(name)) {
            return null;
        }
        if (this.policies == null) {
            return null;
        }
        Vector results = null;
        int i = 0;
        while (i < this.policies.length) {
            Enumeration result = this.getPolicyImplementation(i).loadResources(name);
            if (result != null) {
                if (results == null) {
                    results = new Vector(this.policies.length);
                }
                while (result.hasMoreElements()) {
                    Object url = result.nextElement();
                    if (results.contains(url)) continue;
                    results.add(url);
                }
            }
            ++i;
        }
        this.stopLoading(name);
        return results == null || results.isEmpty() ? null : results.elements();
    }

    private boolean startLoading(String name) {
        HashSet<String> classesAndResources = (HashSet<String>)this.beingLoaded.get();
        if (classesAndResources != null && classesAndResources.contains(name)) {
            return false;
        }
        if (classesAndResources == null) {
            classesAndResources = new HashSet<String>(3);
            this.beingLoaded.set(classesAndResources);
        }
        classesAndResources.add(name);
        return true;
    }

    private void stopLoading(String name) {
        ((Set)this.beingLoaded.get()).remove(name);
    }

    public void close() {
        this.policedLoader.bundle.framework.systemBundle.context.removeBundleListener(this.listener);
    }
}

