/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.osgi.framework.internal.core;

import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import orika_shaded.org.eclipse.osgi.framework.internal.core.AbstractBundle;
import orika_shaded.org.eclipse.osgi.framework.internal.core.BundleHost;
import orika_shaded.org.eclipse.osgi.framework.internal.core.BundleLoader;
import orika_shaded.org.eclipse.osgi.framework.internal.core.PackageSource;
import orika_shaded.org.eclipse.osgi.framework.internal.core.ServiceRegistrationImpl;
import orika_shaded.org.eclipse.osgi.framework.internal.core.SystemBundleLoader;

public class ServiceReferenceImpl
implements ServiceReference,
Comparable {
    protected ServiceRegistrationImpl registration;

    protected ServiceReferenceImpl(ServiceRegistrationImpl registration) {
        this.registration = registration;
    }

    public Object getProperty(String key) {
        return this.registration.getProperty(key);
    }

    public String[] getPropertyKeys() {
        return this.registration.getPropertyKeys();
    }

    public Bundle getBundle() {
        return this.registration.getBundle();
    }

    public Bundle[] getUsingBundles() {
        return this.registration.getUsingBundles();
    }

    protected String[] getClasses() {
        return this.registration.clazzes;
    }

    protected long getId() {
        return this.registration.serviceid;
    }

    protected int getRanking() {
        return this.registration.serviceranking;
    }

    public int hashCode() {
        return this.registration.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServiceReferenceImpl)) {
            return false;
        }
        ServiceReferenceImpl other = (ServiceReferenceImpl)obj;
        return this.registration == other.registration;
    }

    public String toString() {
        return this.registration.toString();
    }

    public int compareTo(Object object) {
        ServiceReferenceImpl other = (ServiceReferenceImpl)object;
        if (this.getRanking() != other.getRanking()) {
            return this.getRanking() > other.getRanking() ? -1 : 1;
        }
        return this.getId() == other.getId() ? 0 : (this.getId() > other.getId() ? 1 : -1);
    }

    public boolean isAssignableTo(Bundle bundle, String className) {
        SystemBundleLoader systemLoader;
        AbstractBundle consumer = (AbstractBundle)bundle;
        if (consumer.isFragment()) {
            return false;
        }
        BundleHost producer = (BundleHost)this.registration.bundle;
        if (consumer == producer) {
            return true;
        }
        String pkgName = BundleLoader.getPackageName(className);
        if (pkgName.startsWith("java.")) {
            return true;
        }
        BundleLoader producerBL = producer.getBundleLoader();
        if (producerBL == null) {
            return false;
        }
        BundleLoader consumerBL = consumer.getBundleLoader();
        if (consumerBL == null) {
            return false;
        }
        PackageSource consumerSource = consumerBL.getPackageSource(pkgName);
        if (consumerSource == null) {
            return true;
        }
        if (producerBL.isBootDelegationPackage(pkgName) && (systemLoader = (SystemBundleLoader)this.registration.framework.systemBundle.getBundleLoader()).isEEPackage(pkgName)) {
            return true;
        }
        PackageSource producerSource = producerBL.getPackageSource(pkgName);
        if (producerSource == null && (producerSource = this.getPackageSource(this.registration.service.getClass(), pkgName)) == null) {
            return false;
        }
        return producerSource.hasCommonSource(consumerSource);
    }

    private PackageSource getPackageSource(Class serviceClass, String pkgName) {
        if (serviceClass == null) {
            return null;
        }
        AbstractBundle serviceBundle = (AbstractBundle)this.registration.framework.packageAdmin.getBundle(serviceClass);
        if (serviceBundle == null) {
            return null;
        }
        BundleLoader producerBL = serviceBundle.getBundleLoader();
        if (producerBL == null) {
            return null;
        }
        PackageSource producerSource = producerBL.getPackageSource(pkgName);
        if (producerSource != null) {
            return producerSource;
        }
        Class<?>[] interfaces = serviceClass.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            producerSource = this.getPackageSource(interfaces[i], pkgName);
            if (producerSource != null) {
                return producerSource;
            }
            ++i;
        }
        return this.getPackageSource(serviceClass.getSuperclass(), pkgName);
    }
}

