/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.osgi.framework.internal.protocol;

import java.lang.reflect.Method;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import orika_shaded.org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import orika_shaded.org.eclipse.osgi.framework.internal.core.Msg;
import orika_shaded.org.eclipse.osgi.framework.internal.protocol.MultiplexingFactory;
import orika_shaded.org.eclipse.osgi.framework.internal.protocol.MultiplexingURLStreamHandler;
import orika_shaded.org.eclipse.osgi.framework.internal.protocol.ProtocolActivator;
import orika_shaded.org.eclipse.osgi.framework.internal.protocol.URLStreamHandlerProxy;
import orika_shaded.org.eclipse.osgi.framework.log.FrameworkLog;
import orika_shaded.org.eclipse.osgi.framework.log.FrameworkLogEntry;
import orika_shaded.org.eclipse.osgi.framework.util.SecureAction;
import orika_shaded.org.eclipse.osgi.util.NLS;

public class StreamHandlerFactory
extends MultiplexingFactory
implements URLStreamHandlerFactory {
    static final SecureAction secureAction = (SecureAction)AccessController.doPrivileged(SecureAction.createSecureAction());
    private ServiceTracker handlerTracker;
    protected static final String URLSTREAMHANDLERCLASS = "org.osgi.service.url.URLStreamHandlerService";
    protected static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    protected static final String INTERNAL_PROTOCOL_HANDLER_PKG = "orika_shaded.org.eclipse.osgi.framework.internal.protocol";
    private static final List ignoredClasses;
    private Hashtable proxies = new Hashtable(15);
    private URLStreamHandlerFactory parentFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("orika_shaded.org.eclipse.osgi.framework.internal.protocol.MultiplexingURLStreamHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("orika_shaded.org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        ignoredClasses = Arrays.asList(classArray);
    }

    public StreamHandlerFactory(BundleContext context, FrameworkAdaptor adaptor) {
        super(context, adaptor);
        this.handlerTracker = new ServiceTracker(context, URLSTREAMHANDLERCLASS, null);
        this.handlerTracker.open();
    }

    private Class getBuiltIn(String protocol, String builtInHandlers, boolean fromFramework) {
        if (builtInHandlers == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(builtInHandlers, "|");
        while (tok.hasMoreElements()) {
            StringBuffer name = new StringBuffer();
            name.append(tok.nextToken());
            name.append(".");
            name.append(protocol);
            name.append(".Handler");
            try {
                Class clazz = fromFramework ? secureAction.forName(name.toString()) : secureAction.loadSystemClass(name.toString());
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        String builtInHandlers = secureAction.getProperty(PROTOCOL_HANDLER_PKGS);
        Class clazz = this.getBuiltIn(protocol, builtInHandlers, false);
        if (clazz != null) {
            return null;
        }
        URLStreamHandler result = null;
        if (this.isMultiplexing()) {
            if (this.findAuthorizedURLStreamHandler(protocol) != null) {
                result = new MultiplexingURLStreamHandler(protocol, this);
            }
        } else {
            result = this.createInternalURLStreamHandler(protocol);
        }
        if (result == null && this.parentFactory != null) {
            result = this.parentFactory.createURLStreamHandler(protocol);
        }
        return result;
    }

    public URLStreamHandler createInternalURLStreamHandler(String protocol) {
        String internalHandlerPkgs = secureAction.getProperty("equinox.interal.handler.pkgs");
        internalHandlerPkgs = internalHandlerPkgs == null ? INTERNAL_PROTOCOL_HANDLER_PKG : String.valueOf(internalHandlerPkgs) + '|' + INTERNAL_PROTOCOL_HANDLER_PKG;
        Class clazz = this.getBuiltIn(protocol, internalHandlerPkgs, true);
        if (clazz == null) {
            URLStreamHandlerProxy handler = (URLStreamHandlerProxy)this.proxies.get(protocol);
            if (handler != null) {
                return handler;
            }
            ServiceReference[] serviceReferences = this.handlerTracker.getServiceReferences();
            if (serviceReferences == null) {
                return null;
            }
            int i = 0;
            while (i < serviceReferences.length) {
                String[] prop = serviceReferences[i].getProperty("url.handler.protocol");
                if (prop instanceof String) {
                    prop = new String[]{(String)prop};
                }
                if (!(prop instanceof String[])) {
                    String message = NLS.bind(Msg.URL_HANDLER_INCORRECT_TYPE, new Object[]{"url.handler.protocol", URLSTREAMHANDLERCLASS, serviceReferences[i].getBundle()});
                    this.adaptor.getFrameworkLog().log(new FrameworkLogEntry("orika_shaded.org.eclipse.osgi", 2, 0, message, 0, null, null));
                } else {
                    String[] protocols = prop;
                    int j = 0;
                    while (j < protocols.length) {
                        if (protocols[j].equals(protocol)) {
                            handler = new URLStreamHandlerProxy(protocol, serviceReferences[i], this.context);
                            this.proxies.put(protocol, handler);
                            return handler;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return null;
        }
        try {
            URLStreamHandler handler = (URLStreamHandler)clazz.newInstance();
            if (handler instanceof ProtocolActivator) {
                ((ProtocolActivator)((Object)handler)).start(this.context, this.adaptor);
            }
            return handler;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected URLStreamHandler findAuthorizedURLStreamHandler(String protocol) {
        Object factory = this.findAuthorizedFactory(ignoredClasses);
        if (factory == null) {
            return null;
        }
        if (factory == this) {
            return this.createInternalURLStreamHandler(protocol);
        }
        try {
            Class<?> clazz = factory.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method createInternalURLStreamHandlerMethod = clazz.getMethod("createInternalURLStreamHandler", classArray);
            return (URLStreamHandler)createInternalURLStreamHandlerMethod.invoke(factory, protocol);
        }
        catch (Exception e) {
            FrameworkLog frameworkLog = this.adaptor.getFrameworkLog();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("orika_shaded.org.eclipse.osgi.framework.internal.protocol.StreamHandlerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            frameworkLog.log(new FrameworkLogEntry(clazz.getName(), "findAuthorizedURLStreamHandler-loop", 4, e, null));
            throw new RuntimeException(e.getMessage());
        }
    }

    public Object getParentFactory() {
        return this.parentFactory;
    }

    public void setParentFactory(Object parentFactory) {
        if (this.parentFactory == null) {
            this.parentFactory = (URLStreamHandlerFactory)parentFactory;
        }
    }
}

