/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.core.internal.registry;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class HashtableOfInt {
    private int[] keyTable;
    private int[] valueTable;
    private static final float GROWTH_FACTOR = 1.33f;
    private int elementSize = 0;
    private int threshold;

    public HashtableOfInt() {
        this(13);
    }

    public HashtableOfInt(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.33f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.keyTable = new int[extraRoom];
        this.valueTable = new int[extraRoom];
    }

    public boolean containsKey(int key) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                return true;
            }
            index = (index + 1) % this.keyTable.length;
        }
        return false;
    }

    public int get(int key) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return Integer.MIN_VALUE;
    }

    public int removeKey(int key) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        return Integer.MIN_VALUE;
    }

    public int put(int key, int value) {
        int currentKey;
        int index = key % this.valueTable.length;
        while ((currentKey = this.keyTable[index]) != 0) {
            if (currentKey == key) {
                this.valueTable[index] = value;
                return this.valueTable[index];
            }
            index = (index + 1) % this.keyTable.length;
        }
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return value;
    }

    private void rehash() {
        HashtableOfInt newHashtable = new HashtableOfInt((int)((float)this.elementSize * 1.33f));
        int i = this.keyTable.length;
        while (--i >= 0) {
            int currentKey = this.keyTable[i];
            if (currentKey == 0) continue;
            newHashtable.put(currentKey, this.valueTable[i]);
        }
        this.keyTable = newHashtable.keyTable;
        this.valueTable = newHashtable.valueTable;
        this.threshold = newHashtable.threshold;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String s = "";
        int i = 0;
        int length = this.valueTable.length;
        while (i < length) {
            int object = this.valueTable[i];
            if (object != Integer.MIN_VALUE) {
                s = String.valueOf(s) + this.keyTable[i] + " -> " + object + "\n";
            }
            ++i;
        }
        return s;
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeInt(this.elementSize);
        int tableSize = this.keyTable.length;
        out.writeInt(tableSize);
        out.writeInt(this.threshold);
        int i = 0;
        while (i < tableSize) {
            out.writeInt(this.keyTable[i]);
            out.writeInt(this.valueTable[i]);
            ++i;
        }
    }

    public void load(DataInputStream in) throws IOException {
        this.elementSize = in.readInt();
        int tableSize = in.readInt();
        this.threshold = in.readInt();
        boolean fastMode = true;
        if ((double)tableSize / (double)this.elementSize < (double)1.33f) {
            this.keyTable = new int[(int)((float)this.elementSize * 1.33f)];
            this.valueTable = new int[(int)((float)this.elementSize * 1.33f)];
            this.elementSize = 0;
            fastMode = false;
        } else {
            this.keyTable = new int[tableSize];
            this.valueTable = new int[tableSize];
        }
        int i = 0;
        while (i < tableSize) {
            int key = in.readInt();
            int value = in.readInt();
            if (fastMode) {
                this.keyTable[i] = key;
                this.valueTable[i] = value;
            } else {
                this.put(key, value);
            }
            ++i;
        }
    }
}

