/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.core.internal.registry.osgi;

import java.io.File;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import orika_shaded.org.eclipse.core.internal.registry.RegistryMessages;
import orika_shaded.org.eclipse.core.internal.registry.osgi.Activator;
import orika_shaded.org.eclipse.core.internal.registry.osgi.EquinoxUtils;
import orika_shaded.org.eclipse.core.internal.registry.osgi.ExtensionEventDispatcherJob;
import orika_shaded.org.eclipse.core.internal.registry.osgi.OSGIUtils;
import orika_shaded.org.eclipse.core.internal.registry.osgi.RegistryStrategyOSGI;
import orika_shaded.org.eclipse.core.internal.runtime.RuntimeLog;
import orika_shaded.org.eclipse.core.runtime.IStatus;
import orika_shaded.org.eclipse.core.runtime.Status;

public class EquinoxRegistryStrategy
extends RegistryStrategyOSGI {
    public static final String PLUGIN_NAME = "orika_shaded.org.eclipse.equinox.registry";
    public static final String OPTION_DEBUG = "org.eclipse.equinox.registry/debug";
    public static final String OPTION_DEBUG_EVENTS = "org.eclipse.equinox.registry/debug/events";
    private static boolean DEBUG_ECLIPSE_REGISTRY = OSGIUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.registry/debug", false);
    private static boolean DEBUG_ECLIPSE_EVENTS = OSGIUtils.getDefault().getBooleanDebugOption("org.eclipse.equinox.registry/debug/events", false);
    private boolean useJobs = true;

    public EquinoxRegistryStrategy(File[] theStorageDir, boolean[] cacheReadOnly, Object key) {
        super(theStorageDir, cacheReadOnly, key);
    }

    public boolean debug() {
        return DEBUG_ECLIPSE_REGISTRY;
    }

    public boolean debugRegistryEvents() {
        return DEBUG_ECLIPSE_EVENTS;
    }

    public final void log(IStatus status) {
        RuntimeLog.log(status);
    }

    public long getContainerTimestamp() {
        BundleContext context = Activator.getContext();
        if (context == null) {
            RuntimeLog.log(new Status(4, PLUGIN_NAME, 0, RegistryMessages.bundle_not_activated, null));
            return -1L;
        }
        ServiceReference ref = context.getServiceReference("orika_shaded.org.eclipse.osgi.service.resolver.PlatformAdmin");
        if (ref == null) {
            return -1L;
        }
        return EquinoxUtils.getContainerTimestamp(context, ref);
    }

    public final void scheduleChangeEvent(Object[] listeners, Map deltas, Object registry) {
        if (this.useJobs) {
            try {
                new ExtensionEventDispatcherJob(listeners, deltas, registry).schedule();
                return;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.useJobs = false;
            }
        }
        super.scheduleChangeEvent(listeners, deltas, registry);
    }
}

