/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import orika_shaded.org.eclipse.osgi.framework.debug.Debug;
import orika_shaded.org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import orika_shaded.org.eclipse.osgi.framework.internal.core.Constants;
import orika_shaded.org.eclipse.osgi.framework.internal.core.FilterImpl;
import orika_shaded.org.eclipse.osgi.framework.util.Headers;
import orika_shaded.org.eclipse.osgi.framework.util.KeyedElement;
import orika_shaded.org.eclipse.osgi.framework.util.KeyedHashSet;
import orika_shaded.org.eclipse.osgi.internal.baseadaptor.StateManager;
import orika_shaded.org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import orika_shaded.org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import orika_shaded.org.eclipse.osgi.internal.resolver.GenericSpecificationImpl;
import orika_shaded.org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import orika_shaded.org.eclipse.osgi.internal.resolver.ResolverErrorImpl;
import orika_shaded.org.eclipse.osgi.internal.resolver.StateBuilder;
import orika_shaded.org.eclipse.osgi.internal.resolver.StateDeltaImpl;
import orika_shaded.org.eclipse.osgi.internal.resolver.StateHelperImpl;
import orika_shaded.org.eclipse.osgi.internal.resolver.StateReader;
import orika_shaded.org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import orika_shaded.org.eclipse.osgi.service.resolver.BaseDescription;
import orika_shaded.org.eclipse.osgi.service.resolver.BundleDescription;
import orika_shaded.org.eclipse.osgi.service.resolver.ExportPackageDescription;
import orika_shaded.org.eclipse.osgi.service.resolver.GenericDescription;
import orika_shaded.org.eclipse.osgi.service.resolver.GenericSpecification;
import orika_shaded.org.eclipse.osgi.service.resolver.HostSpecification;
import orika_shaded.org.eclipse.osgi.service.resolver.Resolver;
import orika_shaded.org.eclipse.osgi.service.resolver.ResolverError;
import orika_shaded.org.eclipse.osgi.service.resolver.State;
import orika_shaded.org.eclipse.osgi.service.resolver.StateDelta;
import orika_shaded.org.eclipse.osgi.service.resolver.StateHelper;
import orika_shaded.org.eclipse.osgi.service.resolver.StateObjectFactory;
import orika_shaded.org.eclipse.osgi.service.resolver.VersionConstraint;
import orika_shaded.org.eclipse.osgi.util.ManifestElement;

public abstract class StateImpl
implements State {
    public static final String[] PROPS = new String[]{"osgi.os", "osgi.ws", "osgi.nl", "osgi.arch", "org.osgi.framework.system.packages", "osgi.resolverMode", "org.osgi.framework.executionenvironment", "osgi.resolveOptional", "osgi.genericAliases"};
    private transient Resolver resolver;
    private transient StateDeltaImpl changes;
    private transient boolean resolving = false;
    private transient HashSet removalPendings = new HashSet();
    private boolean resolved = true;
    private long timeStamp = System.currentTimeMillis();
    private KeyedHashSet bundleDescriptions = new KeyedHashSet(false);
    private HashMap resolverErrors = new HashMap();
    private StateObjectFactory factory;
    private KeyedHashSet resolvedBundles = new KeyedHashSet();
    boolean fullyLoaded = false;
    private boolean dynamicCacheChanged = false;
    private StateReader reader;
    private Dictionary[] platformProperties = new Dictionary[]{new Hashtable(PROPS.length)};
    private long highestBundleId = -1L;
    private HashSet platformPropertyKeys = new HashSet(PROPS.length);
    private static long cumulativeTime;

    protected StateImpl() {
        this.addPlatformPropertyKeys(PROPS);
    }

    public boolean addBundle(BundleDescription description) {
        if (!this.basicAddBundle(description)) {
            return false;
        }
        String platformFilter = description.getPlatformFilter();
        if (platformFilter != null) {
            try {
                FilterImpl filter = (FilterImpl)FrameworkUtil.createFilter(platformFilter);
                this.addPlatformPropertyKeys(filter.getAttributes());
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        this.resolved = false;
        this.getDelta().recordBundleAdded((BundleDescriptionImpl)description);
        if (Constants.getInternalSymbolicName().equals(description.getSymbolicName())) {
            this.resetSystemExports();
        }
        if (this.resolver != null) {
            this.resolver.bundleAdded(description);
        }
        this.updateTimeStamp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateBundle(BundleDescription newDescription) {
        BundleDescriptionImpl existing = (BundleDescriptionImpl)this.bundleDescriptions.get((BundleDescriptionImpl)newDescription);
        if (existing == null) {
            return false;
        }
        if (!this.bundleDescriptions.remove(existing)) {
            return false;
        }
        this.resolvedBundles.remove(existing);
        existing.setStateBit(4, true);
        if (!this.basicAddBundle(newDescription)) {
            return false;
        }
        this.resolved = false;
        this.getDelta().recordBundleUpdated((BundleDescriptionImpl)newDescription);
        if (Constants.getInternalSymbolicName().equals(newDescription.getSymbolicName())) {
            this.resetSystemExports();
        }
        if (this.resolver != null) {
            boolean pending = existing.getDependents().length > 0;
            this.resolver.bundleUpdated(newDescription, existing, pending);
            if (pending) {
                this.getDelta().recordBundleRemovalPending(existing);
                this.removalPendings.add(existing);
            } else {
                StateImpl stateImpl = this;
                synchronized (stateImpl) {
                    try {
                        this.resolving = true;
                        this.resolverErrors.remove(existing);
                        this.resolveBundle(existing, false, null, null, null, null);
                    }
                    finally {
                        this.resolving = false;
                    }
                }
            }
        }
        this.updateTimeStamp();
        return true;
    }

    public BundleDescription removeBundle(long bundleId) {
        BundleDescription toRemove = this.getBundle(bundleId);
        if (toRemove == null || !this.removeBundle(toRemove)) {
            return null;
        }
        return toRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeBundle(BundleDescription toRemove) {
        if (!this.bundleDescriptions.remove((KeyedElement)((Object)toRemove))) {
            return false;
        }
        this.resolvedBundles.remove((KeyedElement)((Object)toRemove));
        this.resolved = false;
        this.getDelta().recordBundleRemoved((BundleDescriptionImpl)toRemove);
        ((BundleDescriptionImpl)toRemove).setStateBit(4, true);
        if (this.resolver != null) {
            boolean pending = toRemove.getDependents().length > 0;
            this.resolver.bundleRemoved(toRemove, pending);
            if (pending) {
                this.getDelta().recordBundleRemovalPending((BundleDescriptionImpl)toRemove);
                this.removalPendings.add(toRemove);
            } else {
                StateImpl stateImpl = this;
                synchronized (stateImpl) {
                    try {
                        this.resolving = true;
                        this.resolverErrors.remove(toRemove);
                        this.resolveBundle(toRemove, false, null, null, null, null);
                    }
                    finally {
                        this.resolving = false;
                    }
                }
            }
        }
        this.updateTimeStamp();
        return true;
    }

    public StateDelta getChanges() {
        return this.getDelta();
    }

    private StateDeltaImpl getDelta() {
        if (this.changes == null) {
            this.changes = new StateDeltaImpl(this);
        }
        return this.changes;
    }

    public BundleDescription[] getBundles(String symbolicName) {
        if ("system.bundle".equals(symbolicName)) {
            symbolicName = Constants.getInternalSymbolicName();
        }
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>();
        Iterator iter = this.bundleDescriptions.iterator();
        while (iter.hasNext()) {
            BundleDescription bundle = (BundleDescription)iter.next();
            if (!symbolicName.equals(bundle.getSymbolicName())) continue;
            bundles.add(bundle);
        }
        return bundles.toArray(new BundleDescription[bundles.size()]);
    }

    public BundleDescription[] getBundles() {
        return (BundleDescription[])this.bundleDescriptions.elements(new BundleDescription[this.bundleDescriptions.size()]);
    }

    public BundleDescription getBundle(long id) {
        BundleDescription result = (BundleDescription)((Object)this.bundleDescriptions.getByKey(new Long(id)));
        if (result != null) {
            return result;
        }
        Iterator iter = this.removalPendings.iterator();
        while (iter.hasNext()) {
            BundleDescription removedBundle = (BundleDescription)iter.next();
            if (removedBundle.getBundleId() != id) continue;
            return removedBundle;
        }
        return null;
    }

    public BundleDescription getBundle(String name, Version version) {
        BundleDescription[] allBundles = this.getBundles(name);
        if (allBundles.length == 1) {
            return version == null || allBundles[0].getVersion().equals(version) ? allBundles[0] : null;
        }
        if (allBundles.length == 0) {
            return null;
        }
        BaseDescription unresolvedFound = null;
        BaseDescription resolvedFound = null;
        int i = 0;
        while (i < allBundles.length) {
            BundleDescription current = allBundles[i];
            BaseDescription base = current.isResolved() ? resolvedFound : unresolvedFound;
            if (version == null || current.getVersion().equals(version)) {
                if (base != null && (base.getVersion().compareTo(current.getVersion()) <= 0 || base.getBundleId() > current.getBundleId())) {
                    if (base == resolvedFound) {
                        resolvedFound = current;
                    } else {
                        unresolvedFound = current;
                    }
                } else if (current.isResolved()) {
                    resolvedFound = current;
                } else {
                    unresolvedFound = current;
                }
            }
            ++i;
        }
        if (resolvedFound != null) {
            return resolvedFound;
        }
        return unresolvedFound;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isResolved() {
        return this.resolved || this.isEmpty();
    }

    public void resolveConstraint(VersionConstraint constraint, BaseDescription supplier) {
        ((VersionConstraintImpl)constraint).setSupplier(supplier);
    }

    public synchronized void resolveBundle(BundleDescription bundle, boolean status, BundleDescription[] hosts, ExportPackageDescription[] selectedExports, BundleDescription[] resolvedRequires, ExportPackageDescription[] resolvedImports) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        BundleDescriptionImpl modifiable = (BundleDescriptionImpl)bundle;
        this.getDelta().recordBundleResolved(modifiable, status);
        modifiable.setLazyLoaded(false);
        modifiable.setStateBit(1, status);
        if (status) {
            this.resolverErrors.remove(modifiable);
            this.resolvedBundles.add(modifiable);
        } else {
            this.resolvedBundles.remove(modifiable);
            modifiable.removeDependencies();
        }
        if (selectedExports == null || resolvedRequires == null || resolvedImports == null) {
            this.unresolveConstraints(modifiable);
        } else {
            this.resolveConstraints(modifiable, hosts, selectedExports, resolvedRequires, resolvedImports);
        }
    }

    public synchronized void removeBundleComplete(BundleDescription bundle) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        this.getDelta().recordBundleRemovalComplete((BundleDescriptionImpl)bundle);
        this.removalPendings.remove(bundle);
    }

    private void resolveConstraints(BundleDescriptionImpl bundle, BundleDescription[] hosts, ExportPackageDescription[] selectedExports, BundleDescription[] resolvedRequires, ExportPackageDescription[] resolvedImports) {
        HostSpecificationImpl hostSpec = (HostSpecificationImpl)bundle.getHost();
        if (hostSpec != null && hosts != null) {
            hostSpec.setHosts(hosts);
            int i = 0;
            while (i < hosts.length) {
                ((BundleDescriptionImpl)hosts[i]).addDependency(bundle, true);
                ++i;
            }
        }
        bundle.setSelectedExports(selectedExports);
        bundle.setResolvedRequires(resolvedRequires);
        bundle.setResolvedImports(resolvedImports);
        bundle.addDependencies(hosts, true);
        bundle.addDependencies(resolvedRequires, true);
        bundle.addDependencies(resolvedImports, true);
        GenericSpecification[] genericRequires = bundle.getGenericRequires();
        if (genericRequires.length > 0) {
            ArrayList<GenericDescription> genericSuppliers = new ArrayList<GenericDescription>(genericRequires.length);
            int i = 0;
            while (i < genericRequires.length) {
                GenericDescription[] suppliers = genericRequires[i].getSuppliers();
                if (suppliers != null) {
                    int j = 0;
                    while (j < suppliers.length) {
                        genericSuppliers.add(suppliers[j]);
                        ++j;
                    }
                }
                ++i;
            }
            bundle.addDependencies(genericSuppliers.toArray(new BaseDescription[genericSuppliers.size()]), true);
        }
    }

    private void unresolveConstraints(BundleDescriptionImpl bundle) {
        HostSpecificationImpl host = (HostSpecificationImpl)bundle.getHost();
        if (host != null) {
            host.setHosts(null);
        }
        bundle.setSelectedExports(null);
        bundle.setResolvedImports(null);
        bundle.setResolvedRequires(null);
        GenericSpecification[] genericRequires = bundle.getGenericRequires();
        if (genericRequires.length > 0) {
            int i = 0;
            while (i < genericRequires.length) {
                ((GenericSpecificationImpl)genericRequires[i]).setSupplers(null);
                ++i;
            }
        }
        bundle.removeDependencies();
    }

    private synchronized StateDelta resolve(boolean incremental, BundleDescription[] reResolve) {
        try {
            BundleDescription[] removed;
            this.resolving = true;
            if (this.resolver == null) {
                throw new IllegalStateException("no resolver set");
            }
            this.fullyLoad();
            long start = 0L;
            if (StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER) {
                start = System.currentTimeMillis();
            }
            if (!incremental) {
                this.resolved = false;
                reResolve = this.getBundles();
                if (this.removalPendings.size() > 0) {
                    removed = this.getRemovalPendings();
                    reResolve = this.mergeBundles(reResolve, removed);
                }
                this.flush(reResolve);
            }
            if (this.resolved && reResolve == null) {
                StateDeltaImpl stateDeltaImpl = new StateDeltaImpl(this);
                return stateDeltaImpl;
            }
            if (this.removalPendings.size() > 0) {
                removed = this.getRemovalPendings();
                reResolve = this.mergeBundles(reResolve, removed);
            }
            Dictionary[] tmpPlatformProperties = new Headers[this.platformProperties.length];
            int i = 0;
            while (i < this.platformProperties.length) {
                tmpPlatformProperties[i] = new Headers(this.platformProperties[i].size());
                Enumeration keys = this.platformProperties[i].keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    ((Headers)tmpPlatformProperties[i]).put(key, this.platformProperties[i].get(key));
                }
                ++i;
            }
            this.resolver.resolve(reResolve, tmpPlatformProperties);
            this.resolved = this.removalPendings.size() == 0;
            StateDeltaImpl savedChanges = this.changes == null ? new StateDeltaImpl(this) : this.changes;
            this.changes = new StateDeltaImpl(this);
            if (StateManager.DEBUG_PLATFORM_ADMIN_RESOLVER) {
                long time = System.currentTimeMillis() - start;
                Debug.println("Time spent resolving: " + time);
                FrameworkDebugOptions.getDefault().setOption("org.eclipse.core.runtime.adaptor/resolver/timing/value", Long.toString(cumulativeTime += time));
            }
            if (savedChanges.getChanges().length > 0) {
                this.updateTimeStamp();
            }
            StateDeltaImpl stateDeltaImpl = savedChanges;
            return stateDeltaImpl;
        }
        finally {
            this.resolving = false;
        }
    }

    private BundleDescription[] mergeBundles(BundleDescription[] reResolve, BundleDescription[] removed) {
        if (reResolve == null) {
            return removed;
        }
        if (reResolve.length == 0) {
            return reResolve;
        }
        ArrayList<BundleDescription> result = new ArrayList<BundleDescription>(reResolve.length + removed.length);
        int i = 0;
        while (i < reResolve.length) {
            result.add(reResolve[i]);
            ++i;
        }
        i = 0;
        while (i < removed.length) {
            boolean found = false;
            int j = 0;
            while (j < reResolve.length) {
                if (removed[i] == reResolve[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                result.add(removed[i]);
            }
            ++i;
        }
        return result.toArray(new BundleDescription[result.size()]);
    }

    private void flush(BundleDescription[] bundles) {
        this.resolver.flush();
        this.resolved = false;
        this.resolverErrors.clear();
        if (this.resolvedBundles.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < bundles.length) {
            this.resolveBundle(bundles[i], false, null, null, null, null);
            ++i;
        }
        this.resolvedBundles.clear();
    }

    public StateDelta resolve() {
        return this.resolve(true, null);
    }

    public StateDelta resolve(boolean incremental) {
        return this.resolve(incremental, null);
    }

    public StateDelta resolve(BundleDescription[] reResolve) {
        return this.resolve(true, reResolve);
    }

    public void setOverrides(Object value) {
        throw new UnsupportedOperationException();
    }

    public BundleDescription[] getResolvedBundles() {
        return (BundleDescription[])this.resolvedBundles.elements(new BundleDescription[this.resolvedBundles.size()]);
    }

    public boolean isEmpty() {
        return this.bundleDescriptions.isEmpty();
    }

    void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    boolean basicAddBundle(BundleDescription description) {
        ((BundleDescriptionImpl)description).setContainingState(this);
        ((BundleDescriptionImpl)description).setStateBit(4, false);
        if (this.bundleDescriptions.add((BundleDescriptionImpl)description)) {
            if (description.getBundleId() > this.getHighestBundleId()) {
                this.highestBundleId = description.getBundleId();
            }
            return true;
        }
        return false;
    }

    void addResolvedBundle(BundleDescriptionImpl resolvedBundle) {
        this.resolvedBundles.add(resolvedBundle);
    }

    public ExportPackageDescription[] getExportedPackages() {
        int i;
        ExportPackageDescription[] bundlePackages;
        BundleDescription bundle;
        this.fullyLoad();
        ArrayList<ExportPackageDescription> allExportedPackages = new ArrayList<ExportPackageDescription>();
        Iterator iter = this.resolvedBundles.iterator();
        while (iter.hasNext()) {
            bundle = (BundleDescription)iter.next();
            bundlePackages = bundle.getSelectedExports();
            if (bundlePackages == null) continue;
            i = 0;
            while (i < bundlePackages.length) {
                allExportedPackages.add(bundlePackages[i]);
                ++i;
            }
        }
        iter = this.removalPendings.iterator();
        while (iter.hasNext()) {
            bundle = (BundleDescription)iter.next();
            bundlePackages = bundle.getSelectedExports();
            if (bundlePackages == null) continue;
            i = 0;
            while (i < bundlePackages.length) {
                allExportedPackages.add(bundlePackages[i]);
                ++i;
            }
        }
        return allExportedPackages.toArray(new ExportPackageDescription[allExportedPackages.size()]);
    }

    BundleDescription[] getFragments(BundleDescription host) {
        ArrayList<BundleDescription> fragments = new ArrayList<BundleDescription>();
        Iterator iter = this.bundleDescriptions.iterator();
        block0: while (iter.hasNext()) {
            BundleDescription[] hosts;
            BundleDescription bundle = (BundleDescription)iter.next();
            HostSpecification hostSpec = bundle.getHost();
            if (hostSpec == null || (hosts = hostSpec.getHosts()) == null) continue;
            int i = 0;
            while (i < hosts.length) {
                if (hosts[i] == host) {
                    fragments.add(bundle);
                    continue block0;
                }
                ++i;
            }
        }
        return fragments.toArray(new BundleDescription[fragments.size()]);
    }

    public void setTimeStamp(long newTimeStamp) {
        this.timeStamp = newTimeStamp;
    }

    private void updateTimeStamp() {
        if (this.getTimeStamp() == Long.MAX_VALUE) {
            this.setTimeStamp(0L);
        }
        this.setTimeStamp(this.getTimeStamp() + 1L);
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    void setFactory(StateObjectFactory factory) {
        this.factory = factory;
    }

    public BundleDescription getBundleByLocation(String location) {
        Iterator i = this.bundleDescriptions.iterator();
        while (i.hasNext()) {
            BundleDescription current = (BundleDescription)i.next();
            if (!location.equals(current.getLocation())) continue;
            return current;
        }
        return null;
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver newResolver) {
        if (this.resolver == newResolver) {
            return;
        }
        if (this.resolver != null) {
            Resolver oldResolver = this.resolver;
            this.resolver = null;
            oldResolver.setState(null);
        }
        this.resolver = newResolver;
        if (this.resolver == null) {
            return;
        }
        this.resolver.setState(this);
    }

    public boolean setPlatformProperties(Dictionary platformProperties) {
        return this.setPlatformProperties(new Dictionary[]{platformProperties});
    }

    public boolean setPlatformProperties(Dictionary[] platformProperties) {
        return this.setPlatformProperties(platformProperties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean setPlatformProperties(Dictionary[] platformProperties, boolean resetSystemExports) {
        if (platformProperties.length == 0) {
            throw new IllegalArgumentException();
        }
        Dictionary[] newPlatformProperties = new Dictionary[platformProperties.length];
        int i = 0;
        while (i < platformProperties.length) {
            newPlatformProperties[i] = new Hashtable(platformProperties[i].size());
            Dictionary dictionary = platformProperties[i];
            synchronized (dictionary) {
                Enumeration keys = platformProperties[i].keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    newPlatformProperties[i].put(key, platformProperties[i].get(key));
                }
            }
            ++i;
        }
        boolean result = false;
        if (this.platformProperties.length != newPlatformProperties.length) {
            result = true;
        } else {
            String[] keys = this.getPlatformPropertyKeys();
            int i2 = 0;
            while (i2 < newPlatformProperties.length && !result) {
                result |= this.changedProps(this.platformProperties[i2], newPlatformProperties[i2], keys);
                ++i2;
            }
        }
        this.platformProperties = newPlatformProperties;
        if (resetSystemExports && result) {
            this.resetSystemExports();
        }
        return result;
    }

    private void resetSystemExports() {
        BundleDescription[] systemBundles = this.getBundles(Constants.getInternalSymbolicName());
        if (systemBundles.length > 0) {
            BundleDescriptionImpl systemBundle = (BundleDescriptionImpl)systemBundles[0];
            ExportPackageDescription[] exports = systemBundle.getExportPackages();
            ArrayList<ExportPackageDescription> newExports = new ArrayList<ExportPackageDescription>(exports.length);
            int i = 0;
            while (i < exports.length) {
                if ((Integer)exports[i].getDirective("x-equinox-ee") < 0) {
                    newExports.add(exports[i]);
                }
                ++i;
            }
            this.addSystemExports(newExports);
            systemBundle.setExportPackages(newExports.toArray(new ExportPackageDescription[newExports.size()]));
        }
    }

    private void addSystemExports(ArrayList exports) {
        int i = 0;
        while (i < this.platformProperties.length) {
            try {
                ManifestElement[] elements = ManifestElement.parseHeader("Export-Package", (String)this.platformProperties[i].get("org.osgi.framework.system.packages"));
                if (elements != null) {
                    ExportPackageDescription[] systemExports = StateBuilder.createExportPackages(elements, null, null, null, 2, false);
                    Integer profInx = new Integer(i);
                    int j = 0;
                    while (j < systemExports.length) {
                        ((ExportPackageDescriptionImpl)systemExports[j]).setDirective("x-equinox-ee", profInx);
                        exports.add(systemExports[j]);
                        ++j;
                    }
                }
            }
            catch (BundleException bundleException) {}
            ++i;
        }
    }

    public Dictionary[] getPlatformProperties() {
        return this.platformProperties;
    }

    private boolean checkProp(Object origObj, Object newObj) {
        if (origObj == null && newObj != null || origObj != null && newObj == null) {
            return true;
        }
        if (origObj == null) {
            return false;
        }
        if (origObj.getClass() != newObj.getClass()) {
            return true;
        }
        if (origObj instanceof String) {
            return !origObj.equals(newObj);
        }
        String[] origProps = (String[])origObj;
        String[] newProps = (String[])newObj;
        if (origProps.length != newProps.length) {
            return true;
        }
        int i = 0;
        while (i < origProps.length) {
            if (!origProps[i].equals(newProps[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean changedProps(Dictionary origProps, Dictionary newProps, String[] keys) {
        int i = 0;
        while (i < keys.length) {
            Object newProp;
            Object origProp = origProps.get(keys[i]);
            if (this.checkProp(origProp, newProp = newProps.get(keys[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public BundleDescription[] getRemovalPendings() {
        return this.removalPendings.toArray(new BundleDescription[this.removalPendings.size()]);
    }

    public synchronized ExportPackageDescription linkDynamicImport(BundleDescription importingBundle, String requestedPackage) {
        if (this.resolver == null) {
            throw new IllegalStateException("no resolver set");
        }
        BundleDescriptionImpl importer = (BundleDescriptionImpl)importingBundle;
        if (importer.getDynamicStamp(requestedPackage) == this.getTimeStamp()) {
            return null;
        }
        try {
            this.resolving = true;
            this.fullyLoad();
            ExportPackageDescriptionImpl result = (ExportPackageDescriptionImpl)this.resolver.resolveDynamicImport(importingBundle, requestedPackage);
            if (result == null) {
                importer.setDynamicStamp(requestedPackage, new Long(this.getTimeStamp()));
            } else {
                importer.setDynamicStamp(requestedPackage, null);
                importer.addDynamicResolvedImport(result);
            }
            this.setDynamicCacheChanged(true);
            ExportPackageDescriptionImpl exportPackageDescriptionImpl = result;
            return exportPackageDescriptionImpl;
        }
        finally {
            this.resolving = false;
        }
    }

    void setReader(StateReader reader) {
        this.reader = reader;
    }

    StateReader getReader() {
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullyLoad() {
        if (this.reader == null) {
            return;
        }
        StateReader stateReader = this.reader;
        synchronized (stateReader) {
            if (this.fullyLoaded) {
                return;
            }
            if (this.reader.isLazyLoaded()) {
                this.reader.fullyLoad();
            }
            this.fullyLoaded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadLazyData(long expireTime) {
        StateReader stateReader = this.reader;
        synchronized (stateReader) {
            if (this.reader.getAccessedFlag()) {
                this.reader.setAccessedFlag(false);
                return;
            }
            this.fullyLoaded = false;
            BundleDescription[] bundles = this.getBundles();
            int i = 0;
            while (i < bundles.length) {
                ((BundleDescriptionImpl)bundles[i]).unload();
                ++i;
            }
        }
    }

    public ExportPackageDescription[] getSystemPackages() {
        ArrayList<ExportPackageDescription> result = new ArrayList<ExportPackageDescription>();
        BundleDescription[] systemBundles = this.getBundles(Constants.getInternalSymbolicName());
        if (systemBundles.length > 0) {
            BundleDescriptionImpl systemBundle = (BundleDescriptionImpl)systemBundles[0];
            ExportPackageDescription[] exports = systemBundle.getExportPackages();
            int i = 0;
            while (i < exports.length) {
                if ((Integer)exports[i].getDirective("x-equinox-ee") >= 0) {
                    result.add(exports[i]);
                }
                ++i;
            }
        }
        return result.toArray(new ExportPackageDescription[result.size()]);
    }

    boolean inStrictMode() {
        return "strict".equals(this.getPlatformProperties()[0].get("osgi.resolverMode"));
    }

    public synchronized ResolverError[] getResolverErrors(BundleDescription bundle) {
        if (bundle.isResolved()) {
            return new ResolverError[0];
        }
        ArrayList result = (ArrayList)this.resolverErrors.get(bundle);
        return result == null ? new ResolverError[]{} : result.toArray(new ResolverError[result.size()]);
    }

    public synchronized void addResolverError(BundleDescription bundle, int type, String data, VersionConstraint unsatisfied) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        ArrayList<ResolverErrorImpl> errors = (ArrayList<ResolverErrorImpl>)this.resolverErrors.get(bundle);
        if (errors == null) {
            errors = new ArrayList<ResolverErrorImpl>(1);
            this.resolverErrors.put(bundle, errors);
        }
        errors.add(new ResolverErrorImpl((BundleDescriptionImpl)bundle, type, data, unsatisfied));
    }

    public synchronized void removeResolverErrors(BundleDescription bundle) {
        if (!this.resolving) {
            throw new IllegalStateException();
        }
        this.resolverErrors.remove(bundle);
    }

    public boolean dynamicCacheChanged() {
        return this.dynamicCacheChanged;
    }

    void setDynamicCacheChanged(boolean dynamicCacheChanged) {
        this.dynamicCacheChanged = dynamicCacheChanged;
    }

    public StateHelper getStateHelper() {
        return StateHelperImpl.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPlatformPropertyKeys(String[] keys) {
        HashSet hashSet = this.platformPropertyKeys;
        synchronized (hashSet) {
            int i = 0;
            while (i < keys.length) {
                if (!this.platformPropertyKeys.contains(keys[i])) {
                    this.platformPropertyKeys.add(keys[i]);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getPlatformPropertyKeys() {
        HashSet hashSet = this.platformPropertyKeys;
        synchronized (hashSet) {
            return this.platformPropertyKeys.toArray(new String[this.platformPropertyKeys.size()]);
        }
    }

    public long getHighestBundleId() {
        return this.highestBundleId;
    }
}

