/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.core.internal.registry.osgi;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.SynchronousBundleListener;
import orika_shaded.org.eclipse.core.internal.registry.ExtensionRegistry;
import orika_shaded.org.eclipse.core.internal.registry.RegistryMessages;
import orika_shaded.org.eclipse.core.internal.registry.osgi.OSGIUtils;
import orika_shaded.org.eclipse.core.internal.registry.osgi.RegistryStrategyOSGI;
import orika_shaded.org.eclipse.core.internal.runtime.ResourceTranslator;
import orika_shaded.org.eclipse.core.internal.runtime.RuntimeLog;
import orika_shaded.org.eclipse.core.runtime.ContributorFactoryOSGi;
import orika_shaded.org.eclipse.core.runtime.IContributor;
import orika_shaded.org.eclipse.core.runtime.Status;
import orika_shaded.org.eclipse.osgi.util.ManifestElement;
import orika_shaded.org.eclipse.osgi.util.NLS;

public class EclipseBundleListener
implements SynchronousBundleListener {
    private static final String PLUGIN_MANIFEST = "plugin.xml";
    private static final String FRAGMENT_MANIFEST = "fragment.xml";
    private ExtensionRegistry registry;
    private RegistryStrategyOSGI strategy;
    private Object token;

    public EclipseBundleListener(ExtensionRegistry registry, Object key, RegistryStrategyOSGI strategy) {
        this.registry = registry;
        this.token = key;
        this.strategy = strategy;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        switch (event.getType()) {
            case 32: {
                this.addBundle(bundle);
                break;
            }
            case 64: {
                this.removeBundle(bundle);
            }
        }
    }

    public void processBundles(Bundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            if (this.isBundleResolved(bundles[i])) {
                this.addBundle(bundles[i]);
            } else {
                this.removeBundle(bundles[i]);
            }
            ++i;
        }
    }

    private boolean isBundleResolved(Bundle bundle) {
        return (bundle.getState() & 0x3C) != 0;
    }

    private void removeBundle(Bundle bundle) {
        URL pluginManifest;
        long timestamp = 0L;
        if (this.strategy.checkContributionsTimestamp() && (pluginManifest = EclipseBundleListener.getExtensionURL(bundle, false)) != null) {
            timestamp = this.strategy.getExtendedTimestamp(bundle, pluginManifest);
        }
        this.registry.remove(Long.toString(bundle.getBundleId()), timestamp);
    }

    public static URL getExtensionURL(Bundle bundle, boolean report) {
        if (bundle.getBundleId() == 0L) {
            return null;
        }
        if (bundle.getSymbolicName() == null) {
            return null;
        }
        boolean isFragment = OSGIUtils.getDefault().isFragment(bundle);
        String manifestName = isFragment ? FRAGMENT_MANIFEST : PLUGIN_MANIFEST;
        URL extensionURL = bundle.getEntry(manifestName);
        if (extensionURL == null) {
            return null;
        }
        if (!EclipseBundleListener.isSingleton(bundle)) {
            if (report) {
                String message = NLS.bind(RegistryMessages.parse_nonSingleton, bundle.getLocation());
                RuntimeLog.log(new Status(1, "orika_shaded.org.eclipse.equinox.registry", 0, message, null));
            }
            return null;
        }
        if (!isFragment) {
            return extensionURL;
        }
        Bundle[] hosts = OSGIUtils.getDefault().getHosts(bundle);
        if (hosts == null) {
            return null;
        }
        if (EclipseBundleListener.isSingleton(hosts[0])) {
            return extensionURL;
        }
        if (report) {
            String message = NLS.bind(RegistryMessages.parse_nonSingleton, hosts[0].getLocation());
            RuntimeLog.log(new Status(1, "orika_shaded.org.eclipse.equinox.registry", 0, message, null));
        }
        return null;
    }

    private void addBundle(Bundle bundle) {
        BufferedInputStream is;
        String contributorId = Long.toString(bundle.getBundleId());
        if (this.registry.hasContribution(contributorId)) {
            return;
        }
        URL pluginManifest = EclipseBundleListener.getExtensionURL(bundle, this.registry.debug());
        if (pluginManifest == null) {
            return;
        }
        try {
            is = new BufferedInputStream(pluginManifest.openStream());
        }
        catch (IOException iOException) {
            is = null;
        }
        if (is == null) {
            return;
        }
        ResourceBundle translationBundle = null;
        try {
            translationBundle = ResourceTranslator.getResourceBundle(bundle);
        }
        catch (MissingResourceException missingResourceException) {}
        long timestamp = 0L;
        if (this.strategy.checkContributionsTimestamp()) {
            timestamp = this.strategy.getExtendedTimestamp(bundle, pluginManifest);
        }
        IContributor contributor = ContributorFactoryOSGi.createContributor(bundle);
        this.registry.addContribution(is, contributor, true, pluginManifest.getPath(), translationBundle, this.token, timestamp);
    }

    private static boolean isSingleton(Bundle bundle) {
        Dictionary allHeaders = bundle.getHeaders("");
        String symbolicNameHeader = (String)allHeaders.get("Bundle-SymbolicName");
        try {
            ManifestElement[] symbolicNameElements;
            if (symbolicNameHeader != null && (symbolicNameElements = ManifestElement.parseHeader("Bundle-SymbolicName", symbolicNameHeader)).length > 0) {
                String singleton = symbolicNameElements[0].getDirective("singleton");
                if (singleton == null) {
                    singleton = symbolicNameElements[0].getAttribute("singleton");
                }
                if (!"true".equalsIgnoreCase(singleton)) {
                    String manifestVersion = (String)allHeaders.get("Bundle-ManifestVersion");
                    return manifestVersion == null && OSGIUtils.getDefault().getBundle(symbolicNameElements[0].getValue()) == bundle;
                }
            }
        }
        catch (BundleException bundleException) {}
        return true;
    }
}

