/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.net.URL;
import org.osgi.framework.Bundle;
import orika_shaded.org.eclipse.core.internal.boot.PlatformURLConnection;
import orika_shaded.org.eclipse.core.internal.boot.PlatformURLHandler;
import orika_shaded.org.eclipse.core.internal.runtime.Activator;
import orika_shaded.org.eclipse.core.internal.runtime.CommonMessages;
import orika_shaded.org.eclipse.osgi.util.NLS;

public class PlatformURLPluginConnection
extends PlatformURLConnection {
    private Bundle target = null;
    private static boolean isRegistered = false;
    public static final String PLUGIN = "plugin";
    static /* synthetic */ Class class$0;

    public PlatformURLPluginConnection(URL url) {
        super(url);
    }

    protected boolean allowCaching() {
        return true;
    }

    protected URL resolve() throws IOException {
        String spec = this.url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith(PLUGIN)) {
            throw new IOException(NLS.bind(CommonMessages.url_badVariant, this.url));
        }
        int ix = spec.indexOf("/", PLUGIN.length() + 1);
        String ref = ix == -1 ? spec.substring(PLUGIN.length() + 1) : spec.substring(PLUGIN.length() + 1, ix);
        String id = this.getId(ref);
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw new IOException(CommonMessages.activator_not_available);
        }
        this.target = activator.getBundle(id);
        if (this.target == null) {
            throw new IOException(NLS.bind(CommonMessages.url_resolvePlugin, this.url));
        }
        if (ix == -1 || ix + 1 >= spec.length()) {
            return this.target.getEntry("/");
        }
        URL result = this.target.getEntry(spec.substring(ix + 1));
        if (result != null) {
            return result;
        }
        return new URL(this.target.getEntry("/"), spec.substring(ix + 1));
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("orika_shaded.org.eclipse.core.internal.runtime.PlatformURLPluginConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformURLHandler.register(PLUGIN, clazz);
        isRegistered = true;
    }

    public URL[] getAuxillaryURLs() throws IOException {
        Bundle[] fragments;
        int fragmentLength;
        if (this.target == null) {
            String spec = this.url.getFile().trim();
            if (spec.startsWith("/")) {
                spec = spec.substring(1);
            }
            if (!spec.startsWith(PLUGIN)) {
                throw new IOException(NLS.bind(CommonMessages.url_badVariant, this.url));
            }
            int ix = spec.indexOf("/", PLUGIN.length() + 1);
            String ref = ix == -1 ? spec.substring(PLUGIN.length() + 1) : spec.substring(PLUGIN.length() + 1, ix);
            String id = this.getId(ref);
            Activator activator = Activator.getDefault();
            if (activator == null) {
                throw new IOException(CommonMessages.activator_not_available);
            }
            this.target = activator.getBundle(id);
            if (this.target == null) {
                throw new IOException(NLS.bind(CommonMessages.url_resolvePlugin, this.url));
            }
        }
        int n = fragmentLength = (fragments = Activator.getDefault().getFragments(this.target)) == null ? 0 : fragments.length;
        if (fragmentLength == 0) {
            return null;
        }
        URL[] result = new URL[fragmentLength];
        int i = 0;
        while (i < fragmentLength) {
            result[i] = fragments[i].getEntry("/");
            ++i;
        }
        return result;
    }
}

