/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.core.runtime;

import orika_shaded.org.eclipse.core.internal.runtime.Activator;
import orika_shaded.org.eclipse.core.internal.runtime.CommonMessages;
import orika_shaded.org.eclipse.core.internal.runtime.RuntimeLog;
import orika_shaded.org.eclipse.core.runtime.Assert;
import orika_shaded.org.eclipse.core.runtime.CoreException;
import orika_shaded.org.eclipse.core.runtime.ISafeRunnable;
import orika_shaded.org.eclipse.core.runtime.MultiStatus;
import orika_shaded.org.eclipse.core.runtime.OperationCanceledException;
import orika_shaded.org.eclipse.core.runtime.Status;
import orika_shaded.org.eclipse.osgi.util.NLS;

public final class SafeRunner {
    public static void run(ISafeRunnable code) {
        Assert.isNotNull(code);
        try {
            code.run();
        }
        catch (Exception e) {
            SafeRunner.handleException(code, e);
        }
        catch (LinkageError e) {
            SafeRunner.handleException(code, e);
        }
    }

    private static void handleException(ISafeRunnable code, Throwable e) {
        if (!(e instanceof OperationCanceledException)) {
            Status status;
            Activator activator = Activator.getDefault();
            String pluginId = null;
            if (activator != null) {
                pluginId = activator.getBundleId(code);
            }
            if (pluginId == null) {
                pluginId = "orika_shaded.org.eclipse.equinox.common";
            }
            String message = NLS.bind(CommonMessages.meta_pluginProblems, pluginId);
            if (e instanceof CoreException) {
                status = new MultiStatus(pluginId, 2, message, e);
                status.merge(((CoreException)e).getStatus());
            } else {
                status = new Status(4, pluginId, 2, message, e);
            }
            if (!RuntimeLog.isEmpty()) {
                RuntimeLog.log(status);
            } else {
                e.printStackTrace();
            }
        }
        code.handleException(e);
    }
}

