/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import orika_shaded.org.eclipse.jdt.core.compiler.InvalidInputException;
import orika_shaded.org.eclipse.jdt.core.dom.AST;
import orika_shaded.org.eclipse.jdt.core.dom.ASTMatcher;
import orika_shaded.org.eclipse.jdt.core.dom.ASTNode;
import orika_shaded.org.eclipse.jdt.core.dom.ASTVisitor;
import orika_shaded.org.eclipse.jdt.core.dom.Expression;
import orika_shaded.org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import orika_shaded.org.eclipse.jdt.internal.compiler.parser.Scanner;

public class StringLiteral
extends Expression {
    public static final SimplePropertyDescriptor ESCAPED_VALUE_PROPERTY;
    private static final List PROPERTY_DESCRIPTORS;
    private String escapedValue = "\"\"";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("orika_shaded.org.eclipse.jdt.core.dom.StringLiteral");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ESCAPED_VALUE_PROPERTY = new SimplePropertyDescriptor(clazz2, "escapedValue", clazz, true);
        ArrayList propertyList = new ArrayList(2);
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("orika_shaded.org.eclipse.jdt.core.dom.StringLiteral");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringLiteral.createPropertyList(clazz3, propertyList);
        StringLiteral.addProperty(ESCAPED_VALUE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = StringLiteral.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    StringLiteral(AST ast) {
        super(ast);
    }

    final List internalStructuralPropertiesForType(int apiLevel) {
        return StringLiteral.propertyDescriptors(apiLevel);
    }

    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == ESCAPED_VALUE_PROPERTY) {
            if (get) {
                return this.getEscapedValue();
            }
            this.setEscapedValue((String)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    final int getNodeType0() {
        return 45;
    }

    ASTNode clone0(AST target) {
        StringLiteral result = new StringLiteral(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setEscapedValue(this.getEscapedValue());
        return result;
    }

    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    void accept0(ASTVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    public String getEscapedValue() {
        return this.escapedValue;
    }

    public void setEscapedValue(String token) {
        if (token == null) {
            throw new IllegalArgumentException("Token cannot be null");
        }
        Scanner scanner = this.ast.scanner;
        char[] source = token.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 52: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid string literal : >" + token + "<");
                }
            }
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException("Invalid string literal : >" + token + "<");
        }
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = token;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    void internalSetEscapedValue(String token) {
        this.preValueChange(ESCAPED_VALUE_PROPERTY);
        this.escapedValue = token;
        this.postValueChange(ESCAPED_VALUE_PROPERTY);
    }

    public String getLiteralValue() {
        String s = this.getEscapedValue();
        int len = s.length();
        if (len < 2 || s.charAt(0) != '\"' || s.charAt(len - 1) != '\"') {
            throw new IllegalArgumentException();
        }
        Scanner scanner = this.ast.scanner;
        char[] source = s.toCharArray();
        scanner.setSource(source);
        scanner.resetTo(0, source.length);
        try {
            int tokenType = scanner.getNextToken();
            switch (tokenType) {
                case 52: {
                    return scanner.getCurrentStringLiteral();
                }
            }
            throw new IllegalArgumentException();
        }
        catch (InvalidInputException invalidInputException) {
            throw new IllegalArgumentException();
        }
    }

    public void setLiteralValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        int len = value.length();
        StringBuffer b = new StringBuffer(len + 2);
        b.append("\"");
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            switch (c) {
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\"': {
                    b.append("\\\"");
                    break;
                }
                case '\'': {
                    b.append("\\'");
                    break;
                }
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '\u0000': {
                    b.append("\\0");
                    break;
                }
                case '\u0001': {
                    b.append("\\1");
                    break;
                }
                case '\u0002': {
                    b.append("\\2");
                    break;
                }
                case '\u0003': {
                    b.append("\\3");
                    break;
                }
                case '\u0004': {
                    b.append("\\4");
                    break;
                }
                case '\u0005': {
                    b.append("\\5");
                    break;
                }
                case '\u0006': {
                    b.append("\\6");
                    break;
                }
                case '\u0007': {
                    b.append("\\7");
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            ++i;
        }
        b.append("\"");
        this.setEscapedValue(b.toString());
    }

    int memSize() {
        int size = 44 + StringLiteral.stringSize(this.escapedValue);
        return size;
    }

    int treeSize() {
        return this.memSize();
    }
}

