/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.RequiredBundle;
import orika_shaded.org.eclipse.osgi.framework.internal.core.AbstractBundle;
import orika_shaded.org.eclipse.osgi.framework.internal.core.BundleHost;
import orika_shaded.org.eclipse.osgi.framework.internal.core.BundleLoader;
import orika_shaded.org.eclipse.osgi.framework.internal.core.FilteredSourcePackage;
import orika_shaded.org.eclipse.osgi.framework.internal.core.PackageSource;
import orika_shaded.org.eclipse.osgi.framework.internal.core.SingleSourcePackage;
import orika_shaded.org.eclipse.osgi.framework.internal.core.SystemBundleLoader;
import orika_shaded.org.eclipse.osgi.framework.util.KeyedHashSet;
import orika_shaded.org.eclipse.osgi.service.resolver.BundleDescription;
import orika_shaded.org.eclipse.osgi.service.resolver.ExportPackageDescription;

public class BundleLoaderProxy
implements RequiredBundle {
    private BundleLoader loader;
    private final BundleHost bundle;
    private final BundleDescription description;
    private boolean stale = false;
    private final KeyedHashSet pkgSources;

    public BundleLoaderProxy(BundleHost bundle, BundleDescription description) {
        this.bundle = bundle;
        this.description = description;
        this.pkgSources = new KeyedHashSet(false);
    }

    synchronized BundleLoader getBundleLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        if (this.bundle.isResolved()) {
            try {
                this.loader = this.bundle.getBundleId() == 0L ? new SystemBundleLoader(this.bundle, this) : new BundleLoader(this.bundle, this);
            }
            catch (BundleException e) {
                this.bundle.framework.publishFrameworkEvent(2, this.bundle, e);
                return null;
            }
        }
        return this.loader;
    }

    BundleLoader getBasicBundleLoader() {
        return this.loader;
    }

    AbstractBundle getBundleHost() {
        return this.bundle;
    }

    void setStale() {
        this.stale = true;
    }

    boolean isStale() {
        return this.stale;
    }

    public String toString() {
        String symbolicName = this.bundle.getSymbolicName();
        StringBuffer sb = new StringBuffer(symbolicName == null ? this.bundle.getBundleData().getLocation() : symbolicName);
        sb.append("; ").append("bundle-version");
        sb.append("=\"").append(this.description.getVersion().toString()).append("\"");
        return sb.toString();
    }

    public Bundle getBundle() {
        if (this.isStale()) {
            return null;
        }
        return this.bundle;
    }

    public Bundle[] getRequiringBundles() {
        if (this.isStale()) {
            return null;
        }
        BundleDescription[] dependents = this.description.getDependents();
        if (dependents == null || dependents.length == 0) {
            return null;
        }
        ArrayList result = new ArrayList(dependents.length);
        int i = 0;
        while (i < dependents.length) {
            this.addRequirers(dependents[i], result);
            ++i;
        }
        return result.size() == 0 ? null : result.toArray(new Bundle[result.size()]);
    }

    void addRequirers(BundleDescription dependent, ArrayList result) {
        if (dependent.getHost() != null) {
            return;
        }
        BundleLoaderProxy dependentProxy = this.getBundleLoader().getLoaderProxy(dependent);
        if (dependentProxy == null) {
            return;
        }
        if (result.contains(dependentProxy.bundle)) {
            return;
        }
        BundleLoader dependentLoader = dependentProxy.getBundleLoader();
        BundleLoaderProxy[] requiredBundles = dependentLoader.requiredBundles;
        int[] reexportTable = dependentLoader.reexportTable;
        if (requiredBundles == null) {
            return;
        }
        int size = reexportTable == null ? 0 : reexportTable.length;
        int reexportIndex = 0;
        int i = 0;
        while (i < requiredBundles.length) {
            if (requiredBundles[i] == this) {
                result.add(dependentProxy.bundle);
                if (reexportIndex < size && reexportTable[reexportIndex] == i) {
                    ++reexportIndex;
                    BundleDescription[] dependents = dependent.getDependents();
                    if (dependents == null) {
                        return;
                    }
                    int j = 0;
                    while (j < dependents.length) {
                        dependentProxy.addRequirers(dependents[j], result);
                        ++j;
                    }
                }
                return;
            }
            ++i;
        }
    }

    public String getSymbolicName() {
        return this.description.getSymbolicName();
    }

    public Version getVersion() {
        return this.description.getVersion();
    }

    public boolean isRemovalPending() {
        return this.description.isRemovalPending();
    }

    BundleDescription getBundleDescription() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageSource getPackageSource(String pkgName) {
        PackageSource pkgSource = (PackageSource)this.pkgSources.getByKey(pkgName);
        if (pkgSource == null) {
            pkgSource = new SingleSourcePackage(pkgName, -1, this);
            KeyedHashSet keyedHashSet = this.pkgSources;
            synchronized (keyedHashSet) {
                this.pkgSources.add(pkgSource);
            }
        }
        return pkgSource;
    }

    boolean inUse() {
        return this.description.getDependents().length > 0;
    }

    boolean forceSourceCreation(ExportPackageDescription export) {
        if (!export.isRoot()) {
            return true;
        }
        boolean strict = "strict".equals(this.bundle.framework.adaptor.getState().getPlatformProperties()[0].get("osgi.resolverMode"));
        return export.getDirective("include") != null || export.getDirective("exclude") != null || strict && export.getDirective("x-friends") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageSource createPackageSource(ExportPackageDescription export, boolean storeSource) {
        PackageSource pkgSource = null;
        if (!export.isRoot()) {
            pkgSource = new ReexportPackageSource(export.getName());
        } else {
            boolean strict;
            String includes = (String)export.getDirective("include");
            String excludes = (String)export.getDirective("exclude");
            String[] friends = (String[])export.getDirective("x-friends");
            if (friends != null && !(strict = "strict".equals(this.bundle.framework.adaptor.getState().getPlatformProperties()[0].get("osgi.resolverMode")))) {
                friends = null;
            }
            if (includes != null || excludes != null || friends != null) {
                ExportPackageDescription[] exports = this.description.getExportPackages();
                int index = -1;
                int first = -1;
                int i = 0;
                while (i < exports.length) {
                    if (first == -1 && exports[i].getName().equals(export.getName())) {
                        first = i;
                    }
                    if (exports[i] == export && first != i) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                pkgSource = new FilteredSourcePackage(export.getName(), index, this, includes, excludes, friends);
            }
        }
        if (storeSource) {
            if (pkgSource != null && this.pkgSources.getByKey(export.getName()) == null) {
                KeyedHashSet keyedHashSet = this.pkgSources;
                synchronized (keyedHashSet) {
                    this.pkgSources.add(pkgSource);
                }
            }
        } else if (pkgSource == null) {
            pkgSource = this.getPackageSource(export.getName());
        }
        return pkgSource;
    }

    class ReexportPackageSource
    extends PackageSource {
        public ReexportPackageSource(String id) {
            super(id);
        }

        public synchronized SingleSourcePackage[] getSuppliers() {
            PackageSource source = BundleLoaderProxy.this.getBundleLoader().getPackageSource(this.id);
            if (source == null) {
                return null;
            }
            return source.getSuppliers();
        }

        public Class loadClass(String name) {
            try {
                return BundleLoaderProxy.this.getBundleLoader().findClass(name, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        public URL getResource(String name) {
            return BundleLoaderProxy.this.getBundleLoader().findResource(name, false);
        }

        public Enumeration getResources(String name) throws IOException {
            return BundleLoaderProxy.this.getBundleLoader().findResources(name);
        }
    }
}

