/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.osgi.framework.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.osgi.framework.Version;
import orika_shaded.org.eclipse.osgi.framework.internal.core.AbstractBundle;
import orika_shaded.org.eclipse.osgi.framework.internal.core.Constants;
import orika_shaded.org.eclipse.osgi.framework.util.KeyedHashSet;

public class BundleRepository {
    private ArrayList bundlesByInstallOrder;
    private KeyedHashSet bundlesById;
    private HashMap bundlesBySymbolicName;

    public BundleRepository(int initialCapacity) {
        this.bundlesByInstallOrder = new ArrayList(initialCapacity);
        this.bundlesById = new KeyedHashSet(initialCapacity, true);
        this.bundlesBySymbolicName = new HashMap(initialCapacity);
    }

    public List getBundles() {
        return this.bundlesByInstallOrder;
    }

    public AbstractBundle getBundle(long bundleId) {
        Long key = new Long(bundleId);
        return (AbstractBundle)this.bundlesById.getByKey(key);
    }

    public AbstractBundle[] getBundles(String symbolicName) {
        if ("system.bundle".equals(symbolicName)) {
            symbolicName = Constants.getInternalSymbolicName();
        }
        return (AbstractBundle[])this.bundlesBySymbolicName.get(symbolicName);
    }

    public AbstractBundle getBundle(String symbolicName, Version version) {
        AbstractBundle[] bundles = this.getBundles(symbolicName);
        if (bundles != null && bundles.length > 0) {
            int i = 0;
            while (i < bundles.length) {
                if (bundles[i].getVersion().equals(version)) {
                    return bundles[i];
                }
                ++i;
            }
        }
        return null;
    }

    public void add(AbstractBundle bundle) {
        this.bundlesByInstallOrder.add(bundle);
        this.bundlesById.add(bundle);
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null) {
            AbstractBundle[] bundles = (AbstractBundle[])this.bundlesBySymbolicName.get(symbolicName);
            if (bundles == null) {
                bundles = new AbstractBundle[]{bundle};
                this.bundlesBySymbolicName.put(symbolicName, bundles);
                return;
            }
            ArrayList<AbstractBundle> list = new ArrayList<AbstractBundle>(bundles.length + 1);
            Version newVersion = bundle.getVersion();
            boolean added = false;
            int i = 0;
            while (i < bundles.length) {
                AbstractBundle oldBundle = bundles[i];
                Version oldVersion = oldBundle.getVersion();
                if (!added && newVersion.compareTo(oldVersion) >= 0) {
                    added = true;
                    list.add(bundle);
                }
                list.add(oldBundle);
                ++i;
            }
            if (!added) {
                list.add(bundle);
            }
            bundles = new AbstractBundle[list.size()];
            list.toArray(bundles);
            this.bundlesBySymbolicName.put(symbolicName, bundles);
        }
    }

    public boolean remove(AbstractBundle bundle) {
        boolean found = this.bundlesById.remove(bundle);
        if (!found) {
            return false;
        }
        this.bundlesByInstallOrder.remove(bundle);
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName == null) {
            return true;
        }
        AbstractBundle[] bundles = (AbstractBundle[])this.bundlesBySymbolicName.get(symbolicName);
        if (bundles == null) {
            return true;
        }
        int numRemoved = 0;
        int i = 0;
        while (i < bundles.length) {
            if (bundle == bundles[i]) {
                ++numRemoved;
                bundles[i] = null;
            }
            ++i;
        }
        if (numRemoved > 0) {
            if (bundles.length - numRemoved <= 0) {
                this.bundlesBySymbolicName.remove(symbolicName);
            } else {
                AbstractBundle[] newBundles = new AbstractBundle[bundles.length - numRemoved];
                int indexCnt = 0;
                int i2 = 0;
                while (i2 < bundles.length) {
                    if (bundles[i2] != null) {
                        newBundles[indexCnt] = bundles[i2];
                        ++indexCnt;
                    }
                    ++i2;
                }
                this.bundlesBySymbolicName.put(symbolicName, newBundles);
            }
        }
        return true;
    }

    public void removeAllBundles() {
        this.bundlesByInstallOrder.clear();
        this.bundlesById = new KeyedHashSet();
        this.bundlesBySymbolicName.clear();
    }
}

