/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import orika_shaded.org.eclipse.core.resources.IContainer;
import orika_shaded.org.eclipse.core.resources.IFile;
import orika_shaded.org.eclipse.core.resources.IResource;
import orika_shaded.org.eclipse.core.resources.IWorkspace;
import orika_shaded.org.eclipse.core.runtime.CoreException;
import orika_shaded.org.eclipse.core.runtime.NullProgressMonitor;
import orika_shaded.org.eclipse.core.runtime.Path;
import orika_shaded.org.eclipse.core.runtime.jobs.ISchedulingRule;
import orika_shaded.org.eclipse.jdt.core.IBuffer;
import orika_shaded.org.eclipse.jdt.core.ICompilationUnit;
import orika_shaded.org.eclipse.jdt.core.IJavaElement;
import orika_shaded.org.eclipse.jdt.core.IJavaModelStatus;
import orika_shaded.org.eclipse.jdt.core.IJavaProject;
import orika_shaded.org.eclipse.jdt.core.IPackageFragment;
import orika_shaded.org.eclipse.jdt.core.JavaConventions;
import orika_shaded.org.eclipse.jdt.core.JavaModelException;
import orika_shaded.org.eclipse.jdt.internal.core.JavaElementDelta;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelOperation;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelStatus;
import orika_shaded.org.eclipse.jdt.internal.core.util.Messages;
import orika_shaded.org.eclipse.jdt.internal.core.util.Util;

public class CreateCompilationUnitOperation
extends JavaModelOperation {
    protected String name;
    protected String source = null;

    public CreateCompilationUnitOperation(IPackageFragment parentElement, String name, String source, boolean force) {
        super(null, new IJavaElement[]{parentElement}, force);
        this.name = name;
        this.source = source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeOperation() throws JavaModelException {
        try {
            this.beginTask(Messages.operation_createUnitProgress, 2);
            JavaElementDelta delta = this.newJavaElementDelta();
            ICompilationUnit unit = this.getCompilationUnit();
            IPackageFragment pkg = (IPackageFragment)this.getParentElement();
            IContainer folder = (IContainer)pkg.getResource();
            this.worked(1);
            IFile compilationUnitFile = folder.getFile(new Path(this.name));
            if (compilationUnitFile.exists()) {
                if (!this.force) throw new JavaModelException(new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, compilationUnitFile.getFullPath().toString())));
                IBuffer buffer = unit.getBuffer();
                if (buffer == null) {
                    return;
                }
                buffer.setContents(this.source);
                unit.save(new NullProgressMonitor(), false);
                this.resultElements = new IJavaElement[]{unit};
                if (!Util.isExcluded(unit) && unit.getParent().exists()) {
                    int i = 0;
                    while (i < this.resultElements.length) {
                        delta.changed(this.resultElements[i], 1);
                        ++i;
                    }
                    this.addDelta(delta);
                }
            } else {
                try {
                    String encoding = null;
                    try {
                        encoding = folder.getDefaultCharset();
                    }
                    catch (CoreException coreException) {}
                    ByteArrayInputStream stream = new ByteArrayInputStream(encoding == null ? this.source.getBytes() : this.source.getBytes(encoding));
                    this.createFile(folder, unit.getElementName(), stream, this.force);
                    this.resultElements = new IJavaElement[]{unit};
                    if (!Util.isExcluded(unit) && unit.getParent().exists()) {
                        int i = 0;
                        while (i < this.resultElements.length) {
                            delta.added(this.resultElements[i]);
                            ++i;
                        }
                        this.addDelta(delta);
                    }
                }
                catch (IOException e) {
                    throw new JavaModelException(e, 985);
                }
            }
            this.worked(1);
            return;
        }
        finally {
            this.done();
        }
    }

    protected ICompilationUnit getCompilationUnit() {
        return ((IPackageFragment)this.getParentElement()).getCompilationUnit(this.name);
    }

    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getCompilationUnit().getResource();
        IWorkspace workspace = resource.getWorkspace();
        if (resource.exists()) {
            return workspace.getRuleFactory().modifyRule(resource);
        }
        return workspace.getRuleFactory().createRule(resource);
    }

    public IJavaModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        IJavaProject project = this.getParentElement().getJavaProject();
        if (JavaConventions.validateCompilationUnitName(this.name, project.getOption("orika_shaded.org.eclipse.jdt.core.compiler.source", true), project.getOption("orika_shaded.org.eclipse.jdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.name);
        }
        if (this.source == null) {
            return new JavaModelStatus(984);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

