/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core;

import orika_shaded.org.eclipse.core.resources.IResourceRuleFactory;
import orika_shaded.org.eclipse.core.resources.ResourcesPlugin;
import orika_shaded.org.eclipse.core.runtime.IPath;
import orika_shaded.org.eclipse.core.runtime.jobs.ISchedulingRule;
import orika_shaded.org.eclipse.core.runtime.jobs.MultiRule;
import orika_shaded.org.eclipse.jdt.core.IClasspathEntry;
import orika_shaded.org.eclipse.jdt.core.IJavaElement;
import orika_shaded.org.eclipse.jdt.core.IJavaModelStatus;
import orika_shaded.org.eclipse.jdt.core.JavaModelException;
import orika_shaded.org.eclipse.jdt.internal.core.ChangeClasspathOperation;
import orika_shaded.org.eclipse.jdt.internal.core.ClasspathChange;
import orika_shaded.org.eclipse.jdt.internal.core.ClasspathEntry;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelManager;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelStatus;
import orika_shaded.org.eclipse.jdt.internal.core.JavaProject;

public class SetClasspathOperation
extends ChangeClasspathOperation {
    IClasspathEntry[] newRawClasspath;
    IClasspathEntry[] referencedEntries;
    IPath newOutputLocation;
    JavaProject project;

    public SetClasspathOperation(JavaProject project, IClasspathEntry[] newRawClasspath, IPath newOutputLocation, boolean canChangeResource) {
        this(project, newRawClasspath, null, newOutputLocation, canChangeResource);
    }

    public SetClasspathOperation(JavaProject project, IClasspathEntry[] newRawClasspath, IClasspathEntry[] referencedEntries, IPath newOutputLocation, boolean canChangeResource) {
        super(new IJavaElement[]{project}, canChangeResource);
        this.project = project;
        this.newRawClasspath = newRawClasspath;
        this.referencedEntries = referencedEntries;
        this.newOutputLocation = newOutputLocation;
    }

    protected void executeOperation() throws JavaModelException {
        this.checkCanceled();
        try {
            JavaModelManager.PerProjectInfo perProjectInfo = this.project.getPerProjectInfo();
            ClasspathChange classpathChange = perProjectInfo.setRawClasspath(this.newRawClasspath, this.referencedEntries, this.newOutputLocation, JavaModelStatus.VERIFIED_OK);
            this.classpathChanged(classpathChange, true);
            if (this.canChangeResources && perProjectInfo.writeAndCacheClasspath(this.project, this.newRawClasspath, this.newOutputLocation)) {
                SetClasspathOperation.setAttribute("hasModifiedResource", "true");
            }
        }
        finally {
            this.done();
        }
    }

    protected ISchedulingRule getSchedulingRule() {
        if (this.canChangeResources) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            return new MultiRule(new ISchedulingRule[]{ruleFactory.modifyRule(this.project.getProject()), ruleFactory.modifyRule(JavaModelManager.getExternalManager().getExternalFoldersProject())});
        }
        return super.getSchedulingRule();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SetClasspathOperation\n");
        buffer.append(" - classpath : ");
        buffer.append("{");
        int i = 0;
        while (i < this.newRawClasspath.length) {
            if (i > 0) {
                buffer.append(",");
            }
            IClasspathEntry element = this.newRawClasspath[i];
            buffer.append(" ").append(element.toString());
            ++i;
        }
        buffer.append("\n - output location : ");
        buffer.append(this.newOutputLocation.toString());
        return buffer.toString();
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        return ClasspathEntry.validateClasspath(this.project, this.newRawClasspath, this.newOutputLocation);
    }
}

