/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core;

import orika_shaded.org.eclipse.jdt.core.ICompilationUnit;
import orika_shaded.org.eclipse.jdt.core.IImportDeclaration;
import orika_shaded.org.eclipse.jdt.core.IJavaElement;
import orika_shaded.org.eclipse.jdt.core.IJavaModelStatus;
import orika_shaded.org.eclipse.jdt.core.IJavaProject;
import orika_shaded.org.eclipse.jdt.core.IType;
import orika_shaded.org.eclipse.jdt.core.JavaConventions;
import orika_shaded.org.eclipse.jdt.core.JavaModelException;
import orika_shaded.org.eclipse.jdt.core.dom.AST;
import orika_shaded.org.eclipse.jdt.core.dom.ASTNode;
import orika_shaded.org.eclipse.jdt.core.dom.CompilationUnit;
import orika_shaded.org.eclipse.jdt.core.dom.Name;
import orika_shaded.org.eclipse.jdt.core.dom.PackageDeclaration;
import orika_shaded.org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import orika_shaded.org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import orika_shaded.org.eclipse.jdt.internal.core.CreateElementInCUOperation;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelStatus;
import orika_shaded.org.eclipse.jdt.internal.core.util.Messages;

public class CreatePackageDeclarationOperation
extends CreateElementInCUOperation {
    protected String name = null;

    public CreatePackageDeclarationOperation(String name, ICompilationUnit parentElement) {
        super(parentElement);
        this.name = name;
    }

    @Override
    protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode parent) {
        return CompilationUnit.PACKAGE_PROPERTY;
    }

    @Override
    protected ASTNode generateElementAST(ASTRewrite rewriter, ICompilationUnit cu) throws JavaModelException {
        IJavaElement[] children = this.getCompilationUnit().getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getElementType() == 11 && this.name.equals(children[i].getElementName())) {
                this.creationOccurred = false;
                return null;
            }
            ++i;
        }
        AST ast = this.cuAST.getAST();
        PackageDeclaration pkgDeclaration = ast.newPackageDeclaration();
        Name astName = ast.newName(this.name);
        pkgDeclaration.setName(astName);
        return pkgDeclaration;
    }

    @Override
    protected IJavaElement generateResultHandle() {
        return this.getCompilationUnit().getPackageDeclaration(this.name);
    }

    @Override
    public String getMainTaskName() {
        return Messages.operation_createPackageProgress;
    }

    @Override
    protected void initializeDefaultPosition() {
        try {
            ICompilationUnit cu = this.getCompilationUnit();
            IImportDeclaration[] imports = cu.getImports();
            if (imports.length > 0) {
                this.createBefore(imports[0]);
                return;
            }
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                this.createBefore(types[0]);
                return;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    @Override
    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IJavaProject project = this.getParentElement().getJavaProject();
        if (JavaConventions.validatePackageName(this.name, project.getOption("orika_shaded.org.eclipse.jdt.core.compiler.source", true), project.getOption("orika_shaded.org.eclipse.jdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.name);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

