/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import orika_shaded.org.eclipse.jdt.core.dom.AST;
import orika_shaded.org.eclipse.jdt.core.dom.ASTMatcher;
import orika_shaded.org.eclipse.jdt.core.dom.ASTNode;
import orika_shaded.org.eclipse.jdt.core.dom.ASTVisitor;
import orika_shaded.org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import orika_shaded.org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import orika_shaded.org.eclipse.jdt.core.dom.Dimension;
import orika_shaded.org.eclipse.jdt.core.dom.SimpleType;
import orika_shaded.org.eclipse.jdt.core.dom.Type;

public class ArrayType
extends Type {
    public static final ChildPropertyDescriptor COMPONENT_TYPE_PROPERTY = new ChildPropertyDescriptor(ArrayType.class, "componentType", Type.class, true, true);
    public static final ChildPropertyDescriptor ELEMENT_TYPE_PROPERTY = new ChildPropertyDescriptor(ArrayType.class, "elementType", Type.class, true, true);
    public static final ChildListPropertyDescriptor DIMENSIONS_PROPERTY = new ChildListPropertyDescriptor(ArrayType.class, "dimensions", Dimension.class, true);
    private static final List PROPERTY_DESCRIPTORS;
    private static final List PROPERTY_DESCRIPTORS_8_0;
    private Type type = null;
    private ASTNode.NodeList dimensions = null;

    static {
        ArrayList propertyList = new ArrayList(2);
        ArrayType.createPropertyList(ArrayType.class, propertyList);
        ArrayType.addProperty(COMPONENT_TYPE_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = ArrayType.reapPropertyList(propertyList);
        propertyList = new ArrayList(3);
        ArrayType.createPropertyList(ArrayType.class, propertyList);
        ArrayType.addProperty(ELEMENT_TYPE_PROPERTY, propertyList);
        ArrayType.addProperty(DIMENSIONS_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS_8_0 = ArrayType.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        switch (apiLevel) {
            case 2: 
            case 3: 
            case 4: {
                return PROPERTY_DESCRIPTORS;
            }
        }
        return PROPERTY_DESCRIPTORS_8_0;
    }

    ArrayType(AST ast) {
        super(ast);
        if (ast.apiLevel >= 8) {
            this.dimensions = new ASTNode.NodeList(this, DIMENSIONS_PROPERTY);
            this.dimensions().add(this.ast.newDimension());
        }
    }

    ArrayType(AST ast, int dimensions) {
        super(ast);
        this.unsupportedIn2_3_4();
        this.dimensions = new ASTNode.NodeList(this, DIMENSIONS_PROPERTY);
        int i = 0;
        while (i < dimensions) {
            this.dimensions().add(this.ast.newDimension());
            ++i;
        }
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return ArrayType.propertyDescriptors(apiLevel);
    }

    @Override
    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == DIMENSIONS_PROPERTY) {
            return this.dimensions();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == COMPONENT_TYPE_PROPERTY) {
            if (get) {
                return this.getComponentType();
            }
            this.setComponentType((Type)child);
            return null;
        }
        if (property == ELEMENT_TYPE_PROPERTY) {
            if (get) {
                return this.getElementType();
            }
            this.setElementType((Type)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 5;
    }

    @Override
    ASTNode clone0(AST target) {
        ArrayType result;
        if (this.ast.apiLevel < 8) {
            result = new ArrayType(target);
            result.setComponentType((Type)this.getComponentType().clone(target));
        } else {
            result = new ArrayType(target, 0);
            result.setElementType((Type)this.getElementType().clone(target));
            result.dimensions().addAll(ASTNode.copySubtrees(target, this.dimensions()));
        }
        result.setSourceRange(this.getStartPosition(), this.getLength());
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            if (this.ast.apiLevel < 8) {
                this.acceptChild(visitor, this.getComponentType());
            } else {
                this.acceptChild(visitor, this.getElementType());
                this.acceptChildren(visitor, this.dimensions);
            }
        }
        visitor.endVisit(this);
    }

    public Type getComponentType() {
        this.supportedOnlyIn2_3_4();
        return this.internalGetType(COMPONENT_TYPE_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Type internalGetType(ChildPropertyDescriptor property) {
        if (this.type == null) {
            ArrayType arrayType = this;
            synchronized (arrayType) {
                if (this.type == null) {
                    this.preLazyInit();
                    this.type = new SimpleType(this.ast);
                    this.postLazyInit(this.type, property);
                }
            }
        }
        return this.type;
    }

    public void setComponentType(Type componentType) {
        this.supportedOnlyIn2_3_4();
        if (componentType == null) {
            throw new IllegalArgumentException();
        }
        this.internalSetType(componentType, COMPONENT_TYPE_PROPERTY);
    }

    private void internalSetType(Type componentType, ChildPropertyDescriptor property) {
        Type oldChild = this.type;
        this.preReplaceChild(oldChild, componentType, property);
        this.type = componentType;
        this.postReplaceChild(oldChild, componentType, property);
    }

    public Type getElementType() {
        if (this.ast.apiLevel() < 8) {
            Type t = this.getComponentType();
            while (t.isArrayType()) {
                t = ((ArrayType)t).getComponentType();
            }
            return t;
        }
        return this.internalGetType(ELEMENT_TYPE_PROPERTY);
    }

    public void setElementType(Type type) {
        this.unsupportedIn2_3_4();
        if (type == null || type instanceof ArrayType) {
            throw new IllegalArgumentException();
        }
        this.internalSetType(type, ELEMENT_TYPE_PROPERTY);
    }

    public int getDimensions() {
        if (this.ast.apiLevel() >= 8) {
            return this.dimensions().size();
        }
        Type t = this.getComponentType();
        int dimension = 1;
        while (t.isArrayType()) {
            ++dimension;
            t = ((ArrayType)t).getComponentType();
        }
        return dimension;
    }

    public List dimensions() {
        if (this.dimensions == null) {
            this.unsupportedIn2_3_4();
        }
        return this.dimensions;
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.type == null ? 0 : (this.ast.apiLevel() < 8 ? this.getComponentType().treeSize() : this.getElementType().treeSize()) + (this.dimensions == null ? 0 : this.dimensions.listSize()));
    }
}

