/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core.util;

import orika_shaded.org.eclipse.jdt.core.util.ClassFormatException;
import orika_shaded.org.eclipse.jdt.core.util.IAnnotationComponent;
import orika_shaded.org.eclipse.jdt.core.util.IAnnotationComponentValue;
import orika_shaded.org.eclipse.jdt.core.util.IConstantPool;
import orika_shaded.org.eclipse.jdt.core.util.IConstantPoolEntry;
import orika_shaded.org.eclipse.jdt.internal.core.util.AnnotationComponentValue;
import orika_shaded.org.eclipse.jdt.internal.core.util.ClassFileStruct;

public class AnnotationComponent
extends ClassFileStruct
implements IAnnotationComponent {
    private int componentNameIndex;
    private char[] componentName;
    private IAnnotationComponentValue componentValue;
    private int readOffset;

    public AnnotationComponent(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        int nameIndex;
        this.componentNameIndex = nameIndex = this.u2At(classFileBytes, 0, offset);
        if (nameIndex != 0) {
            IConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(nameIndex);
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            this.componentName = constantPoolEntry.getUtf8Value();
        }
        this.readOffset = 2;
        AnnotationComponentValue value = new AnnotationComponentValue(classFileBytes, constantPool, offset + this.readOffset);
        this.componentValue = value;
        this.readOffset += value.sizeInBytes();
    }

    @Override
    public int getComponentNameIndex() {
        return this.componentNameIndex;
    }

    @Override
    public char[] getComponentName() {
        return this.componentName;
    }

    @Override
    public IAnnotationComponentValue getComponentValue() {
        return this.componentValue;
    }

    int sizeInBytes() {
        return this.readOffset;
    }
}

