/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import ma.glasnost.orika.impl.generator.ByteCodeClassLoader;
import ma.glasnost.orika.impl.generator.FilePathUtility;
import ma.glasnost.orika.impl.generator.eclipsejdt.CompilationUnit;
import ma.glasnost.orika.impl.generator.eclipsejdt.CompilerRequestor;
import ma.glasnost.orika.impl.generator.eclipsejdt.NameEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import orika_shaded.org.eclipse.jdt.core.ToolFactory;
import orika_shaded.org.eclipse.jdt.core.compiler.IProblem;
import orika_shaded.org.eclipse.jdt.core.formatter.CodeFormatter;
import orika_shaded.org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import orika_shaded.org.eclipse.jdt.internal.compiler.Compiler;
import orika_shaded.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import orika_shaded.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import orika_shaded.org.eclipse.jdt.internal.compiler.IProblemFactory;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import orika_shaded.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import orika_shaded.org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import orika_shaded.org.eclipse.jface.text.Document;
import orika_shaded.org.eclipse.text.edits.TextEdit;

public class EclipseJdtCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseJdtCompiler.class);
    private static final String JAVA_COMPILER_SOURCE_VERSION = "1.5";
    private static final String JAVA_COMPILER_COMPLIANCE_VERSION = "1.5";
    private static final String JAVA_COMPILER_CODEGEN_TARGET_PLATFORM_VERSION = "1.5";
    private static final String JAVA_SOURCE_ENCODING = "UTF-8";
    private final ByteCodeClassLoader byteCodeClassLoader;
    private final CodeFormatter formatter;
    private final NameEnvironment compilerNameEnvironment;
    private final CompilerRequestor compilerRequester;
    private final Compiler compiler;

    public EclipseJdtCompiler() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public EclipseJdtCompiler(ClassLoader parentLoader) {
        this.byteCodeClassLoader = new ByteCodeClassLoader(parentLoader);
        this.formatter = ToolFactory.createCodeFormatter(this.getFormattingOptions());
        this.compilerNameEnvironment = new NameEnvironment(this.byteCodeClassLoader);
        this.compilerRequester = new CompilerRequestor();
        this.compiler = new Compiler((INameEnvironment)this.compilerNameEnvironment, DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.getCompilerOptions(), (ICompilerRequestor)this.compilerRequester, (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()));
    }

    private Map<String, String> getFormattingOptions() {
        Map options = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.compliance", "1.5");
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        return options;
    }

    private CompilerOptions getCompilerOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.problem.suppressWarnings", "enabled");
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.source", "1.5");
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
        options.put("orika_shaded.org.eclipse.jdt.core.encoding", JAVA_SOURCE_ENCODING);
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", "ignore");
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.problem.rawTypeReference", "ignore");
        options.put("orika_shaded.org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", "ignore");
        return new CompilerOptions(options);
    }

    public String formatSource(String code) {
        String lineSeparator = "\n";
        TextEdit te = this.formatter.format(8, code, 0, code.length(), 0, lineSeparator);
        if (te == null) {
            throw new IllegalArgumentException("source code was unable to be formatted; \n//--- BEGIN ---\n" + code + "\n//--- END ---");
        }
        Document doc = new Document(code);
        try {
            te.apply(doc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String formattedCode = doc.get();
        return formattedCode;
    }

    public void assertTypeAccessible(Class<?> type) throws IllegalStateException {
        if (!type.isPrimitive() && type.getClassLoader() != null) {
            String className = type.isArray() ? type.getComponentType().getName() : type.getName();
            try {
                this.byteCodeClassLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(type + " is not accessible", e);
            }
            NameEnvironmentAnswer answer = this.compilerNameEnvironment.findType(className);
            if (answer == null) {
                throw new IllegalStateException(type + " is not accessible");
            }
        }
    }

    public Class<?> compileAndLoad(String source, String packageName, String classSimpleName) throws ClassNotFoundException {
        String className = packageName + "." + classSimpleName;
        return this.load(className, this.compile(source, packageName, classSimpleName));
    }

    public byte[] compile(String source, String packageName, String classSimpleName) {
        Map<String, byte[]> compiledClasses = this.compile(source, packageName, classSimpleName, Thread.currentThread().getContextClassLoader());
        String className = packageName + "." + classSimpleName;
        byte[] data = compiledClasses.get(className);
        return data;
    }

    public ClassLoader compile(File sourceDir, ClassLoader parent) throws IOException {
        Map<String, byte[]> compiledClasses = this.compileClasses(sourceDir);
        ByteCodeClassLoader loader = new ByteCodeClassLoader(parent);
        for (Map.Entry<String, byte[]> compiledClass : compiledClasses.entrySet()) {
            loader.putClassData(compiledClass.getKey(), compiledClass.getValue());
        }
        return loader;
    }

    private Map<String, byte[]> compileClasses(File sourceDir) throws IOException {
        Collection<File> javaSources = FilePathUtility.getJavaSourceFiles(sourceDir);
        if (javaSources == null || javaSources.isEmpty()) {
            LOG.warn("No sources detected at " + sourceDir);
            return Collections.emptyMap();
        }
        ArrayList<CompilationUnit> compilationUnits = new ArrayList<CompilationUnit>();
        for (File javaSource : javaSources) {
            compilationUnits.add(new CompilationUnit(FilePathUtility.readFileAsString(javaSource), FilePathUtility.getJavaPackage(javaSource, sourceDir), FilePathUtility.getJavaClassName(javaSource)));
        }
        Map<String, byte[]> compiledClasses = this.compile(compilationUnits.toArray(new ICompilationUnit[0]));
        return compiledClasses;
    }

    public void compile(File sourceDir, File binDir) throws IOException {
        Map<String, byte[]> compiledClasses = this.compileClasses(sourceDir);
        for (Map.Entry<String, byte[]> compiledClass : compiledClasses.entrySet()) {
            FilePathUtility.writeClassFile(compiledClass.getKey(), compiledClass.getValue(), binDir);
        }
    }

    public Class<?> load(String className, byte[] data) throws ClassNotFoundException {
        this.byteCodeClassLoader.putClassData(className, data);
        return this.byteCodeClassLoader.loadClass(className);
    }

    public byte[] getBytes(String className) {
        return this.byteCodeClassLoader.getBytes(className);
    }

    private Map<String, byte[]> compile(String source, String packageName, String className, ClassLoader classLoader) {
        CompilationUnit unit = new CompilationUnit(source, packageName, className);
        return this.compile(unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, byte[]> compile(ICompilationUnit ... compilationUnits) {
        Map<String, byte[]> compiledClasses = null;
        Compiler compiler = this.compiler;
        synchronized (compiler) {
            this.compilerRequester.reset();
            this.compiler.compile(compilationUnits);
            if (this.compilerRequester.getProblems() != null) {
                StringBuilder warningText = new StringBuilder();
                StringBuilder errorText = new StringBuilder();
                boolean hasErrors = false;
                for (IProblem p : this.compilerRequester.getProblems()) {
                    if (p.isError()) {
                        hasErrors = true;
                        errorText.append("ERROR: " + p.toString() + "\n\n");
                        continue;
                    }
                    warningText.append("WARNING: " + p.toString() + "\n\n");
                }
                if (hasErrors) {
                    throw new RuntimeException("Compilation encountered errors:\n" + errorText.toString() + "\n\n" + warningText.toString());
                }
                LOG.warn("Compiler warnings:" + warningText.toString());
            }
            compiledClasses = this.compilerRequester.getCompiledClassFiles();
        }
        return compiledClasses;
    }
}

