/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

public class FilePathUtility {
    static String readFileAsString(File filePath) throws IOException {
        StringBuffer fileData = new StringBuffer(2048);
        BufferedReader reader = new BufferedReader(new FileReader(filePath));
        char[] buf = new char[2048];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            fileData.append(buf, 0, numRead);
        }
        reader.close();
        return fileData.toString();
    }

    static String getJavaPackage(File sourceFile, File classPathRoot) {
        return sourceFile.getParentFile().getAbsolutePath().replace(classPathRoot.getAbsolutePath(), "").replaceAll("(\\\\|/)", ".").replaceAll("(^\\.|\\.$)", "");
    }

    static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    static String getJavaClassName(File javaSource) {
        return javaSource.getName().replace(".java", "");
    }

    static File getClassFilePath(String key, File binDir) {
        return new File(binDir, key.replace(".", "/") + ".class");
    }

    static void writeClassFile(String className, byte[] classFileBytes, File binDir) throws IOException {
        File destination = FilePathUtility.getClassFilePath(className, binDir);
        if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
            throw new IOException("Could not create class at output path " + destination);
        }
        destination.createNewFile();
        FileOutputStream out = new FileOutputStream(destination);
        out.write(classFileBytes);
        out.close();
    }

    static Collection<File> getJavaSourceFiles(File sourceDir) {
        HashSet<File> javaSources = new HashSet<File>();
        LinkedList<File> stack = new LinkedList<File>();
        stack.add(sourceDir);
        while (!stack.isEmpty()) {
            File current = (File)stack.removeFirst();
            if (!current.exists()) continue;
            if (current.isDirectory()) {
                stack.addAll(Arrays.asList(current.listFiles()));
                continue;
            }
            if (!current.getName().endsWith(".java")) continue;
            javaSources.add(current);
        }
        return javaSources;
    }
}

