/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.core.internal.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.osgi.framework.Bundle;
import orika_shaded.org.eclipse.core.internal.boot.PlatformURLConnection;
import orika_shaded.org.eclipse.core.internal.boot.PlatformURLHandler;
import orika_shaded.org.eclipse.core.internal.runtime.Activator;
import orika_shaded.org.eclipse.core.internal.runtime.CommonMessages;
import orika_shaded.org.eclipse.core.internal.runtime.MetaDataKeeper;
import orika_shaded.org.eclipse.core.runtime.IPath;
import orika_shaded.org.eclipse.osgi.util.NLS;

public class PlatformURLMetaConnection
extends PlatformURLConnection {
    private Bundle target = null;
    private static boolean isRegistered = false;
    public static final String META = "meta";

    public PlatformURLMetaConnection(URL url) {
        super(url);
    }

    @Override
    protected URL resolve() throws IOException {
        String spec = this.url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith(META)) {
            throw new IOException(NLS.bind((String)CommonMessages.url_badVariant, (Object)this.url.toString()));
        }
        int ix = spec.indexOf("/", META.length() + 1);
        String ref = ix == -1 ? spec.substring(META.length() + 1) : spec.substring(META.length() + 1, ix);
        String id = PlatformURLMetaConnection.getId(ref);
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw new IOException(CommonMessages.activator_not_available);
        }
        this.target = activator.getBundle(id);
        if (this.target == null) {
            throw new IOException(NLS.bind((String)CommonMessages.url_resolvePlugin, (Object)this.url.toString()));
        }
        IPath path = MetaDataKeeper.getMetaArea().getStateLocation(this.target);
        if (ix != -1 || ix + 1 <= spec.length()) {
            path = path.append(spec.substring(ix + 1));
        }
        return path.toFile().toURL();
    }

    public static void startup() {
        if (isRegistered) {
            return;
        }
        PlatformURLHandler.register(META, PlatformURLMetaConnection.class);
        isRegistered = true;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        String fileString;
        URL resolved = this.getResolvedURL();
        if (resolved != null && (fileString = resolved.getFile()) != null) {
            File file = new File(fileString);
            String parent = file.getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            return new FileOutputStream(file);
        }
        return null;
    }
}

