/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.core.dom;

import orika_shaded.org.eclipse.core.runtime.IProgressMonitor;
import orika_shaded.org.eclipse.core.runtime.OperationCanceledException;
import orika_shaded.org.eclipse.jdt.core.compiler.CharOperation;
import orika_shaded.org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import orika_shaded.org.eclipse.jdt.internal.compiler.batch.FileSystem;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import orika_shaded.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import orika_shaded.org.eclipse.jdt.internal.core.INameEnvironmentWithProgress;
import orika_shaded.org.eclipse.jdt.internal.core.NameLookup;

class NameEnvironmentWithProgress
extends FileSystem
implements INameEnvironmentWithProgress {
    IProgressMonitor monitor;

    public NameEnvironmentWithProgress(FileSystem.Classpath[] paths, String[] initialFileNames, IProgressMonitor monitor) {
        super(paths, initialFileNames, false);
        this.setMonitor(monitor);
    }

    private void checkCanceled() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            if (NameLookup.VERBOSE) {
                System.out.println(Thread.currentThread() + " CANCELLING LOOKUP ");
            }
            throw new AbortCompilation(true, new OperationCanceledException());
        }
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
        return this.findType(typeName, packageName, true, moduleName);
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, boolean searchWithSecondaryTypes, char[] moduleName) {
        this.checkCanceled();
        NameEnvironmentAnswer answer = super.findType(typeName, packageName, moduleName);
        if (answer == null && searchWithSecondaryTypes) {
            NameEnvironmentAnswer suggestedAnswer = null;
            String qualifiedPackageName = new String(CharOperation.concatWith(packageName, '/'));
            String qualifiedTypeName = new String(CharOperation.concatWith(packageName, typeName, '/'));
            String qualifiedBinaryFileName = String.valueOf(qualifiedTypeName) + ".class";
            int i = 0;
            int length = this.classpaths.length;
            while (i < length) {
                if (this.classpaths[i] instanceof ClasspathDirectory) {
                    ClasspathDirectory classpathDirectory = (ClasspathDirectory)this.classpaths[i];
                    IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
                    if (strategy.matchesWithName(classpathDirectory, loc -> loc.getModule() != null, loc -> loc.servesModule(moduleName)) && (answer = classpathDirectory.findSecondaryInClass(typeName, qualifiedPackageName, qualifiedBinaryFileName)) != null) {
                        if (!answer.ignoreIfBetter()) {
                            if (answer.isBetter(suggestedAnswer)) {
                                return answer;
                            }
                        } else if (answer.isBetter(suggestedAnswer)) {
                            suggestedAnswer = answer;
                        }
                    }
                }
                ++i;
            }
        }
        return answer;
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundName) {
        this.checkCanceled();
        return super.findType(compoundName);
    }

    @Override
    public boolean isPackage(char[][] compoundName, char[] packageName) {
        this.checkCanceled();
        return super.isPackage(compoundName, packageName);
    }

    @Override
    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }
}

