/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.compiler.classfmt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Stream;
import orika_shaded.org.eclipse.jdt.core.compiler.CharOperation;
import orika_shaded.org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IModule;

public class ModuleInfo
extends ClassFileStruct
implements IBinaryModule {
    protected int flags;
    protected int requiresCount;
    protected int exportsCount;
    protected int usesCount;
    protected int providesCount;
    protected int opensCount;
    protected char[] name;
    protected char[] version;
    protected ModuleReferenceInfo[] requires;
    protected PackageExportInfo[] exports;
    protected PackageExportInfo[] opens;
    char[][] uses;
    IModule.IService[] provides;

    @Override
    public boolean isOpen() {
        return (this.flags & 0x20) != 0;
    }

    public int requiresCount() {
        return this.requiresCount;
    }

    public int exportsCount() {
        return this.exportsCount;
    }

    public int usesCount() {
        return this.usesCount;
    }

    public int providesCount() {
        return this.providesCount;
    }

    @Override
    public char[] name() {
        return this.name;
    }

    public void setName(char[] name) {
        this.name = name;
    }

    @Override
    public IModule.IModuleReference[] requires() {
        return this.requires;
    }

    @Override
    public IModule.IPackageExport[] exports() {
        return this.exports;
    }

    @Override
    public char[][] uses() {
        return this.uses;
    }

    @Override
    public IModule.IService[] provides() {
        return this.provides;
    }

    @Override
    public IModule.IPackageExport[] opens() {
        return this.opens;
    }

    @Override
    public void addReads(char[] modName) {
        Predicate<char[]> shouldAdd = m -> Stream.of(this.requires).map(ref -> ref.name()).noneMatch(n -> CharOperation.equals(modName, n));
        if (shouldAdd.test(modName)) {
            int len = this.requires.length;
            this.requires = Arrays.copyOf(this.requires, len);
            ModuleReferenceInfo info = this.requires[len] = new ModuleReferenceInfo();
            info.refName = modName;
        }
    }

    @Override
    public void addExports(IModule.IPackageExport[] toAdd) {
        Predicate<char[]> shouldAdd = m -> Stream.of(this.exports).map(ref -> ref.packageName).noneMatch(n -> CharOperation.equals(m, n));
        Collection merged = Stream.concat(Stream.of(this.exports), Stream.of(toAdd).filter(e -> shouldAdd.test(e.name())).map(e -> {
            PackageExportInfo exp = new PackageExportInfo();
            exp.packageName = e.name();
            exp.exportedTo = e.targets();
            return exp;
        })).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        this.exports = merged.toArray(new PackageExportInfo[merged.size()]);
    }

    protected ModuleInfo(byte[] classFileBytes, int[] offsets, int offset) {
        super(classFileBytes, offsets, offset);
    }

    public static ModuleInfo createModule(char[] className, byte[] classFileBytes, int[] offsets, int offset) {
        char[] exportedToName;
        int k;
        int exportedtoCount;
        char[] exported;
        int count;
        int readOffset = offset;
        int moduleOffset = readOffset + 6;
        ModuleInfo module = new ModuleInfo(classFileBytes, offsets, 0);
        int name_index = module.constantPoolOffsets[module.u2At(moduleOffset)];
        int utf8Offset = module.constantPoolOffsets[module.u2At(name_index + 1)];
        module.name = module.utf8At(utf8Offset + 3, module.u2At(utf8Offset + 1));
        CharOperation.replace(module.name, '/', '.');
        module.flags = module.u2At(moduleOffset += 2);
        int version_index = module.u2At(moduleOffset += 2);
        if (version_index > 0) {
            utf8Offset = module.constantPoolOffsets[version_index];
            module.version = module.utf8At(utf8Offset + 3, module.u2At(utf8Offset + 1));
        }
        utf8Offset = module.constantPoolOffsets[module.u2At(readOffset)];
        module.requiresCount = count = module.u2At(moduleOffset += 2);
        module.requires = new ModuleReferenceInfo[count];
        moduleOffset += 2;
        int i = 0;
        while (i < count) {
            int modifiers;
            name_index = module.constantPoolOffsets[module.u2At(moduleOffset)];
            utf8Offset = module.constantPoolOffsets[module.u2At(name_index + 1)];
            char[] requiresNames = module.utf8At(utf8Offset + 3, module.u2At(utf8Offset + 1));
            module.requires[i] = module.new ModuleReferenceInfo();
            CharOperation.replace(requiresNames, '/', '.');
            module.requires[i].refName = requiresNames;
            module.requires[i].modifiers = modifiers = module.u2At(moduleOffset += 2);
            module.requires[i].isTransitive = (0x20 & modifiers) != 0;
            version_index = module.u2At(moduleOffset += 2);
            if (version_index > 0) {
                utf8Offset = module.constantPoolOffsets[version_index];
                module.requires[i].required_version = module.utf8At(utf8Offset + 3, module.u2At(utf8Offset + 1));
            }
            moduleOffset += 2;
            ++i;
        }
        count = module.u2At(moduleOffset);
        moduleOffset += 2;
        module.exportsCount = count;
        module.exports = new PackageExportInfo[count];
        i = 0;
        while (i < count) {
            PackageExportInfo pack;
            name_index = module.constantPoolOffsets[module.u2At(moduleOffset)];
            utf8Offset = module.constantPoolOffsets[module.u2At(name_index + 1)];
            exported = module.utf8At(utf8Offset + 3, module.u2At(utf8Offset + 1));
            CharOperation.replace(exported, '/', '.');
            module.exports[i] = pack = module.new PackageExportInfo();
            pack.packageName = exported;
            pack.modifiers = module.u2At(moduleOffset += 2);
            exportedtoCount = module.u2At(moduleOffset += 2);
            moduleOffset += 2;
            if (exportedtoCount > 0) {
                pack.exportedTo = new char[exportedtoCount][];
                pack.exportedToCount = exportedtoCount;
                k = 0;
                while (k < exportedtoCount) {
                    name_index = module.constantPoolOffsets[module.u2At(moduleOffset)];
                    utf8Offset = module.constantPoolOffsets[module.u2At(name_index + 1)];
                    exportedToName = module.utf8At(utf8Offset + 3, module.u2At(utf8Offset + 1));
                    CharOperation.replace(exportedToName, '/', '.');
                    pack.exportedTo[k] = exportedToName;
                    moduleOffset += 2;
                    ++k;
                }
            }
            ++i;
        }
        count = module.u2At(moduleOffset);
        moduleOffset += 2;
        module.opensCount = count;
        module.opens = new PackageExportInfo[count];
        i = 0;
        while (i < count) {
            PackageExportInfo pack;
            name_index = module.constantPoolOffsets[module.u2At(moduleOffset)];
            utf8Offset = module.constantPoolOffsets[module.u2At(name_index + 1)];
            exported = module.utf8At(utf8Offset + 3, module.u2At(utf8Offset + 1));
            CharOperation.replace(exported, '/', '.');
            module.opens[i] = pack = module.new PackageExportInfo();
            pack.packageName = exported;
            pack.modifiers = module.u2At(moduleOffset += 2);
            exportedtoCount = module.u2At(moduleOffset += 2);
            moduleOffset += 2;
            if (exportedtoCount > 0) {
                pack.exportedTo = new char[exportedtoCount][];
                pack.exportedToCount = exportedtoCount;
                k = 0;
                while (k < exportedtoCount) {
                    name_index = module.constantPoolOffsets[module.u2At(moduleOffset)];
                    utf8Offset = module.constantPoolOffsets[module.u2At(name_index + 1)];
                    exportedToName = module.utf8At(utf8Offset + 3, module.u2At(utf8Offset + 1));
                    CharOperation.replace(exportedToName, '/', '.');
                    pack.exportedTo[k] = exportedToName;
                    moduleOffset += 2;
                    ++k;
                }
            }
            ++i;
        }
        count = module.u2At(moduleOffset);
        moduleOffset += 2;
        module.usesCount = count;
        module.uses = new char[count][];
        i = 0;
        while (i < count) {
            int classIndex = module.constantPoolOffsets[module.u2At(moduleOffset)];
            utf8Offset = module.constantPoolOffsets[module.u2At(classIndex + 1)];
            char[] inf = module.utf8At(utf8Offset + 3, module.u2At(utf8Offset + 1));
            CharOperation.replace(inf, '/', '.');
            module.uses[i] = inf;
            moduleOffset += 2;
            ++i;
        }
        count = module.u2At(moduleOffset);
        moduleOffset += 2;
        module.providesCount = count;
        module.provides = new ServiceInfo[count];
        i = 0;
        while (i < count) {
            int classIndex = module.constantPoolOffsets[module.u2At(moduleOffset)];
            utf8Offset = module.constantPoolOffsets[module.u2At(classIndex + 1)];
            char[] inf = module.utf8At(utf8Offset + 3, module.u2At(utf8Offset + 1));
            CharOperation.replace(inf, '/', '.');
            ServiceInfo service = module.new ServiceInfo();
            module.provides[i] = service;
            service.serviceName = inf;
            int implCount = module.u2At(moduleOffset += 2);
            moduleOffset += 2;
            service.with = new char[implCount][];
            if (implCount > 0) {
                service.with = new char[implCount][];
                int k2 = 0;
                while (k2 < implCount) {
                    classIndex = module.constantPoolOffsets[module.u2At(moduleOffset)];
                    utf8Offset = module.constantPoolOffsets[module.u2At(classIndex + 1)];
                    char[] implName = module.utf8At(utf8Offset + 3, module.u2At(utf8Offset + 1));
                    CharOperation.replace(implName, '/', '.');
                    service.with[k2] = implName;
                    moduleOffset += 2;
                    ++k2;
                }
            }
            ++i;
        }
        return module;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IModule)) {
            return false;
        }
        IModule mod = (IModule)o;
        if (!CharOperation.equals(this.name, mod.name())) {
            return false;
        }
        return Arrays.equals(this.requires, mod.requires());
    }

    public int hashCode() {
        int result = 17;
        int c = CharOperation.hashCode(this.name);
        result = 31 * result + c;
        c = Arrays.hashCode(this.requires);
        result = 31 * result + c;
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        this.toStringContent(buffer);
        return buffer.toString();
    }

    protected void toStringContent(StringBuffer buffer) {
        int i;
        buffer.append("\nmodule ");
        buffer.append(this.name).append(' ');
        buffer.append('{').append('\n');
        if (this.requiresCount > 0) {
            i = 0;
            while (i < this.requiresCount) {
                buffer.append("\trequires ");
                if (this.requires[i].isTransitive) {
                    buffer.append(" public ");
                }
                buffer.append(this.requires[i].refName);
                buffer.append(';').append('\n');
                ++i;
            }
        }
        if (this.exportsCount > 0) {
            buffer.append('\n');
            i = 0;
            while (i < this.exportsCount) {
                buffer.append("\texports ");
                buffer.append(this.exports[i].toString());
                ++i;
            }
        }
        buffer.append('\n').append('}').toString();
    }

    class ModuleReferenceInfo
    implements IModule.IModuleReference {
        char[] refName;
        boolean isTransitive = false;
        int modifiers;
        char[] required_version;

        ModuleReferenceInfo() {
        }

        @Override
        public char[] name() {
            return this.refName;
        }

        @Override
        public boolean isTransitive() {
            return this.isTransitive;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IModule.IModuleReference)) {
                return false;
            }
            IModule.IModuleReference mod = (IModule.IModuleReference)o;
            if (this.modifiers != mod.getModifiers()) {
                return false;
            }
            return CharOperation.equals(this.refName, mod.name(), false);
        }

        public int hashCode() {
            return CharOperation.hashCode(this.refName);
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }
    }

    class PackageExportInfo
    implements IModule.IPackageExport {
        char[] packageName;
        char[][] exportedTo;
        int exportedToCount;
        int modifiers;

        PackageExportInfo() {
        }

        @Override
        public char[] name() {
            return this.packageName;
        }

        @Override
        public char[][] targets() {
            return this.exportedTo;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            this.toStringContent(buffer);
            return buffer.toString();
        }

        protected void toStringContent(StringBuffer buffer) {
            buffer.append(this.packageName);
            if (this.exportedToCount > 0) {
                buffer.append(" to ");
                int i = 0;
                while (i < this.exportedToCount) {
                    buffer.append(this.exportedTo[i]);
                    buffer.append(',').append(' ');
                    ++i;
                }
            }
            buffer.append(';').append('\n');
        }
    }

    class ServiceInfo
    implements IModule.IService {
        char[] serviceName;
        char[][] with;

        ServiceInfo() {
        }

        @Override
        public char[] name() {
            return this.serviceName;
        }

        @Override
        public char[][] with() {
            return this.with;
        }
    }
}

