/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.compiler.lookup;

import java.util.Collection;
import java.util.HashMap;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import orika_shaded.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import orika_shaded.org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import orika_shaded.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.Binding;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import orika_shaded.org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;

public class SourceModuleBinding
extends ModuleBinding {
    public final CompilationUnitScope scope;
    private SimpleLookupTable storedAnnotations = null;

    public SourceModuleBinding(char[] moduleName, CompilationUnitScope scope, LookupEnvironment rootEnv) {
        super(moduleName);
        rootEnv.knownModules.put(moduleName, this);
        this.environment = new LookupEnvironment(rootEnv, this);
        this.scope = scope;
        scope.environment = this.environment;
    }

    public void setRequires(ModuleBinding[] requires, ModuleBinding[] requiresTransitive) {
        ModuleBinding javaBase = this.environment.javaBaseModule();
        if (javaBase.isUnnamed()) {
            javaBase = null;
        }
        this.requires = this.merge(this.requires, requires, javaBase, ModuleBinding[]::new);
        this.requiresTransitive = this.merge(this.requiresTransitive, requiresTransitive, null, ModuleBinding[]::new);
    }

    public void setUses(TypeBinding[] uses) {
        this.uses = this.merge(this.uses, uses, null, TypeBinding[]::new);
    }

    public void setServices(TypeBinding[] services) {
        this.services = this.merge(this.services, services, null, TypeBinding[]::new);
    }

    public void setImplementations(TypeBinding infBinding, Collection<TypeBinding> resolvedImplementations) {
        if (this.implementations == null) {
            this.implementations = new HashMap();
        }
        this.implementations.put(infBinding, resolvedImplementations.toArray(new TypeBinding[resolvedImplementations.size()]));
    }

    private <T> T[] merge(T[] one, T[] two, T extra, IntFunction<T[]> supplier) {
        if (one.length == 0 && extra == null) {
            if (two.length > 0) {
                return two;
            }
            return one;
        }
        int len0 = extra == null ? 0 : 1;
        int len1 = one.length;
        int len2 = two.length;
        T[] result = supplier.apply(len0 + len1 + len2);
        if (extra != null) {
            result[0] = extra;
        }
        System.arraycopy(one, 0, result, len0, len1);
        System.arraycopy(two, 0, result, len0 + len1, len2);
        return result;
    }

    @Override
    Stream<ModuleBinding> getRequiredModules(boolean transitiveOnly) {
        if (this.requires == NO_MODULES) {
            this.scope.referenceContext.moduleDeclaration.resolveModuleDirectives(this.scope);
        }
        return super.getRequiredModules(transitiveOnly);
    }

    @Override
    public ModuleBinding[] getAllRequiredModules() {
        if (this.scope != null) {
            this.scope.referenceContext.moduleDeclaration.resolveModuleDirectives(this.scope);
        }
        return super.getAllRequiredModules();
    }

    @Override
    public long getAnnotationTagBits() {
        if (((long)this.tagBits & 0x200000000L) == 0L && this.scope != null) {
            ModuleDeclaration module = this.scope.referenceContext.moduleDeclaration;
            ASTNode.resolveAnnotations(module.scope, module.annotations, this);
            if (((long)this.tagBits & 0x400000000000L) != 0L) {
                this.modifiers |= 0x100000;
                this.tagBits = (int)((long)this.tagBits | 0x400000000L);
            }
            this.tagBits = (int)((long)this.tagBits | 0x200000000L);
        }
        return this.tagBits;
    }

    @Override
    public AnnotationBinding[] getAnnotations() {
        return this.retrieveAnnotations(this);
    }

    public AnnotationHolder retrieveAnnotationHolder(Binding binding, boolean forceInitialization) {
        SimpleLookupTable store = this.storedAnnotations(forceInitialization);
        return store == null ? null : (AnnotationHolder)store.get(binding);
    }

    AnnotationBinding[] retrieveAnnotations(Binding binding) {
        AnnotationHolder holder = this.retrieveAnnotationHolder(binding, true);
        return holder == null ? Binding.NO_ANNOTATIONS : holder.getAnnotations();
    }

    @Override
    public void setAnnotations(AnnotationBinding[] annotations) {
        this.storeAnnotations(this, annotations);
    }

    void storeAnnotationHolder(Binding binding, AnnotationHolder holder) {
        if (holder == null) {
            SimpleLookupTable store = this.storedAnnotations(false);
            if (store != null) {
                store.removeKey(binding);
            }
        } else {
            SimpleLookupTable store = this.storedAnnotations(true);
            if (store != null) {
                store.put(binding, holder);
            }
        }
    }

    void storeAnnotations(Binding binding, AnnotationBinding[] annotations) {
        AnnotationHolder holder = null;
        if (annotations == null || annotations.length == 0) {
            SimpleLookupTable store = this.storedAnnotations(false);
            if (store != null) {
                holder = (AnnotationHolder)store.get(binding);
            }
            if (holder == null) {
                return;
            }
        } else {
            SimpleLookupTable store = this.storedAnnotations(true);
            if (store == null) {
                return;
            }
            holder = (AnnotationHolder)store.get(binding);
            if (holder == null) {
                holder = new AnnotationHolder();
            }
        }
        this.storeAnnotationHolder(binding, holder.setAnnotations(annotations));
    }

    SimpleLookupTable storedAnnotations(boolean forceInitialize) {
        if (forceInitialize && this.storedAnnotations == null && this.scope != null) {
            this.scope.referenceCompilationUnit().compilationResult.hasAnnotations = true;
            CompilerOptions globalOptions = this.scope.environment().globalOptions;
            if (!globalOptions.storeAnnotations) {
                return null;
            }
            this.storedAnnotations = new SimpleLookupTable(3);
        }
        return this.storedAnnotations;
    }
}

